/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.xml.infer;

import com.thaiopensource.datatype.DatatypeLibraryLoader;
import com.thaiopensource.util.UriOrFile;
import com.thaiopensource.xml.infer.AttributeDecl;
import com.thaiopensource.xml.infer.ElementDecl;
import com.thaiopensource.xml.infer.InferHandler;
import com.thaiopensource.xml.infer.Particle;
import com.thaiopensource.xml.infer.ParticleDumper;
import com.thaiopensource.xml.infer.Schema;
import com.thaiopensource.xml.sax.Jaxp11XMLReaderCreator;
import com.thaiopensource.xml.util.Name;
import java.io.IOException;
import java.util.Map;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class TestDriver {
    public static void main(String[] stringArray) throws SAXException, IOException {
        InferHandler inferHandler = new InferHandler(new DatatypeLibraryLoader());
        Jaxp11XMLReaderCreator jaxp11XMLReaderCreator = new Jaxp11XMLReaderCreator();
        XMLReader xMLReader = jaxp11XMLReaderCreator.createXMLReader();
        xMLReader.setContentHandler(inferHandler);
        for (int i = 0; i < stringArray.length; ++i) {
            xMLReader.parse(new InputSource(UriOrFile.toUri(stringArray[i])));
        }
        Schema schema = inferHandler.getSchema();
        for (Map.Entry<Name, ElementDecl> entry : schema.getElementDecls().entrySet()) {
            Name name = entry.getKey();
            String string = name.getNamespaceUri();
            if (!string.equals("")) {
                System.out.print("{" + string + "}");
            }
            System.out.print(name.getLocalName());
            System.out.print(" = ");
            ElementDecl elementDecl = entry.getValue();
            Particle particle = elementDecl.getContentModel();
            if (particle != null) {
                System.out.println(ParticleDumper.toString(particle, string));
            } else {
                System.out.println("xsd:" + elementDecl.getDatatype().getLocalName());
            }
            for (Map.Entry<Name, AttributeDecl> entry2 : elementDecl.getAttributeDecls().entrySet()) {
                System.out.print("  @");
                AttributeDecl attributeDecl = entry2.getValue();
                Name name2 = entry2.getKey();
                string = name2.getNamespaceUri();
                if (!string.equals("")) {
                    System.out.print("{" + string + "}");
                }
                System.out.print(name2.getLocalName());
                Name name3 = attributeDecl.getDatatype();
                if (name3 == null) {
                    System.out.print(" string");
                } else {
                    System.out.print(" xsd:" + name3.getLocalName());
                }
                if (attributeDecl.isOptional()) {
                    System.out.println(" optional");
                    continue;
                }
                System.out.println(" required");
            }
        }
    }
}

