// AISDisplayModeApp.cpp: implementation of the CAISDisplayModeApp class.
//
//////////////////////////////////////////////////////////////////////

#include <stdafx.h>

#include "AISDisplayModeApp.h"

#include <OCC_MainFrame.h>
#include <OCC_3dChildFrame.h>
#include <AISDisplayModeView.h>
#include "AISDisplayModeDoc.h"


/////////////////////////////////////////////////////////////////////////////
// CAISDisplayModeApp construction

CAISDisplayModeApp::CAISDisplayModeApp()
{
	SampleName = "AISDisplayMode";		//for about dialog
}
/////////////////////////////////////////////////////////////////////////////
// The one and only CAISDisplayModeApp object

CAISDisplayModeApp theApp;

/////////////////////////////////////////////////////////////////////////////
// CAISDisplayModeApp initialization

BOOL CAISDisplayModeApp::InitInstance()
{
	AfxEnableControlContainer();

	// Standard initialization
	// If you are not using these features and wish to reduce the size
	//  of your final executable, you should remove from the following
	//  the specific initialization routines you do not need.

	// Change the registry key under which our settings are stored.
	// You should modify this string to be something appropriate
	// such as the name of your company or organization.
	SetRegistryKey(_T("Local AppWizard-Generated Applications"));

	LoadStdProfileSettings();  // Load standard INI file options (including MRU)

	// Register the application's document templates.  Document templates
	//  serve as the connection between documents, frame windows and views.

	CMultiDocTemplate* pDocTemplate;
	pDocTemplate = new CMultiDocTemplate(
		IDR_3DTYPE,
		RUNTIME_CLASS(CAISDisplayModeDoc),
		RUNTIME_CLASS(OCC_3dChildFrame),
		RUNTIME_CLASS(CAISDisplayModeView));
	AddDocTemplate(pDocTemplate);

	// create main MDI Frame window
	OCC_MainFrame* pMainFrame = new OCC_MainFrame;
	if (!pMainFrame->LoadFrame(IDR_MAINFRAME))
		return FALSE;
	m_pMainWnd = pMainFrame;

	// Parse command line for standard shell commands, DDE, file open
	CCommandLineInfo cmdInfo;
	ParseCommandLine(cmdInfo);

	// Dispatch commands specified on the command line
	if (!ProcessShellCommand(cmdInfo))
		return FALSE;

	// The main window has been initialized, so show and update it.
	pMainFrame->ShowWindow(m_nCmdShow);
	pMainFrame->UpdateWindow();

	return TRUE;
}


