// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _math_TrigonometricFunctionRoots_HeaderFile
#define _math_TrigonometricFunctionRoots_HeaderFile

#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _TColStd_Array1OfReal_HeaderFile
#include <TColStd_Array1OfReal.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_OStream_HeaderFile
#include <Standard_OStream.hxx>
#endif
class StdFail_NotDone;
class Standard_OutOfRange;
class Standard_RangeError;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! This class implements the solutions of the equation <br>
//!          a*Cos(x)*Cos(x) + 2*b*Cos(x)*Sin(x) + c*Cos(x) + d*Sin(x) + e <br>
//!          The degree of this equation can be 4, 3 or 2. <br>
class math_TrigonometricFunctionRoots  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Given coefficients a, b, c, d , e, this constructor <br>
//!          performs the resolution of the equation above. <br>
//!          The solutions must be contained in [InfBound, SupBound]. <br>
//!          InfBound and SupBound can be set by default to 0 and 2*PI. <br>
Standard_EXPORT math_TrigonometricFunctionRoots(const Standard_Real A,const Standard_Real B,const Standard_Real C,const Standard_Real D,const Standard_Real E,const Standard_Real InfBound,const Standard_Real SupBound);

//! Given the two coefficients d and e, it performs <br>
//!          the resolution of d*sin(x) + e = 0. <br>
//!          The solutions must be contained in [InfBound, SupBound]. <br>
//!          InfBound and SupBound can be set by default to 0 and 2*PI. <br>
Standard_EXPORT math_TrigonometricFunctionRoots(const Standard_Real D,const Standard_Real E,const Standard_Real InfBound,const Standard_Real SupBound);

//! Given the three coefficients c, d and e, it performs <br>
//!          the resolution of 2*b*cos(x)*sin(x) + d*sin(x) + e = 0. <br>
//!          The solutions must be contained in [InfBound, SupBound]. <br>
//!          InfBound and SupBound can be set by default to 0 and 2*PI. <br>
Standard_EXPORT math_TrigonometricFunctionRoots(const Standard_Real C,const Standard_Real D,const Standard_Real E,const Standard_Real InfBound,const Standard_Real SupBound);
//! Returns true if the computations are successful, otherwise returns false. <br>
  Standard_Boolean IsDone() const;
//! Returns true if there is an infinity of roots, otherwise returns false. <br>
  Standard_Boolean InfiniteRoots() const;
//! Returns the solution of range Index. <br>
//!         An exception is raised if NotDone. <br>
//!         An exception is raised if Index>NbSolutions. <br>
//!         An exception is raised if there is an infinity of solutions. <br>
  Standard_Real Value(const Standard_Integer Index) const;
//! Returns the number of solutions found. <br>
//!          An exception is raised if NotDone. <br>
//!         An exception is raised if there is an infinity of solutions. <br>
  Standard_Integer NbSolutions() const;

//! Prints information on the current state of the object. <br>
Standard_EXPORT   void Dump(Standard_OStream& o) const;





protected:

 // Methods PROTECTED
 // 

//! is used by the constructors above. <br>
Standard_EXPORT   void Perform(const Standard_Real A,const Standard_Real B,const Standard_Real C,const Standard_Real D,const Standard_Real E,const Standard_Real InfBound,const Standard_Real SupBound) ;


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Standard_Integer NbSol;
TColStd_Array1OfReal Sol;
Standard_Boolean InfiniteStatus;
Standard_Boolean Done;


};


#include <math_TrigonometricFunctionRoots.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
