// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _math_Powell_HeaderFile
#define _math_Powell_HeaderFile

#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _math_Vector_HeaderFile
#include <math_Vector.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _math_Status_HeaderFile
#include <math_Status.hxx>
#endif
#ifndef _math_Matrix_HeaderFile
#include <math_Matrix.hxx>
#endif
#ifndef _Standard_OStream_HeaderFile
#include <Standard_OStream.hxx>
#endif
class StdFail_NotDone;
class Standard_DimensionError;
class math_MultipleVarFunction;
class math_Vector;
class math_Matrix;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif


//! This class implements the Powell method to find the minimum of <br>
//! function of multiple variables (the gradient does not have to be known). <br>
class math_Powell  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


//! Computes Powell minimization on the function F given <br>
//! StartingPoint, and an initial matrix StartingDirection <br>
//! whose columns contain the initial set of directions. The <br>
//! solution F = Fi is found when 2.0 * abs(Fi - Fi-1) = <br>
//! <Tolerance * (abs(Fi) + abs(Fi-1) + ZEPS). The maximum <br>
//!    number of iterations allowed is given by NbIterations. <br>
Standard_EXPORT math_Powell(math_MultipleVarFunction& F,const math_Vector& StartingPoint,const math_Matrix& StartingDirections,const Standard_Real Tolerance,const Standard_Integer NbIterations = 200,const Standard_Real ZEPS = 1.0e-12);

//! is used in a sub-class to initialize correctly all the fields <br>
//!          of this class. <br>
Standard_EXPORT math_Powell(math_MultipleVarFunction& F,const Standard_Real Tolerance,const Standard_Integer NbIterations = 200,const Standard_Real ZEPS = 1.0e-12);


Standard_EXPORT virtual  void Delete() ;
Standard_EXPORT virtual ~math_Powell(){Delete();}

//! Use this method after a call to the initialization constructor <br>
//! to compute the minimum of function F. <br>
//! Warning <br>
//! The initialization constructor must have been called before <br>
//! the Perform method is called. <br>
Standard_EXPORT   void Perform(math_MultipleVarFunction& F,const math_Vector& StartingPoint,const math_Matrix& StartingDirections) ;


//!  solution F = Fi is found when : <br>
//!   2.0 * abs(Fi - Fi-1) <= Tolerance * (abs(Fi) + abs(Fi-1)) + ZEPS. <br>
//! The maximum number of iterations allowed is given by NbIterations. <br>
Standard_EXPORT virtual  Standard_Boolean IsSolutionReached(math_MultipleVarFunction& F) ;
//! Returns true if the computations are successful, otherwise returns false. <br>
  Standard_Boolean IsDone() const;
//! returns the location vector of the minimum. <br>
//! Exception NotDone is raised if the minimum was not found. <br>
 const math_Vector& Location() const;
//! outputs the location vector of the minimum in Loc. <br>
//! Exception NotDone is raised if the minimum was not found. <br>
//! Exception DimensionError is raised if the range of Loc is not <br>
//! equal to the range of the StartingPoint. <br>
  void Location(math_Vector& Loc) const;
//! Returns the value of the minimum. <br>
//! Exception NotDone is raised if the minimum was not found. <br>
  Standard_Real Minimum() const;
//! Returns the number of iterations really done during the <br>
//! computation of the minimum. <br>
//! Exception NotDone is raised if the minimum was not found. <br>
  Standard_Integer NbIterations() const;

//! Prints information on the current state of the object. <br>
//!          Is used to redefine the operator <<. <br>
Standard_EXPORT   void Dump(Standard_OStream& o) const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //
math_Vector TheLocation;
Standard_Real TheMinimum;
Standard_Real TheLocationError;
Standard_Real PreviousMinimum;
Standard_Real XTol;
Standard_Real EPSZ;


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Standard_Boolean Done;
Standard_Integer Iter;
math_Status TheStatus;
math_Matrix TheDirections;
Standard_Integer State;
Standard_Integer Itermax;


};


#include <math_Powell.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
