// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _math_FunctionAllRoots_HeaderFile
#define _math_FunctionAllRoots_HeaderFile

#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _TColStd_SequenceOfReal_HeaderFile
#include <TColStd_SequenceOfReal.hxx>
#endif
#ifndef _TColStd_SequenceOfInteger_HeaderFile
#include <TColStd_SequenceOfInteger.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_OStream_HeaderFile
#include <Standard_OStream.hxx>
#endif
class Standard_OutOfRange;
class StdFail_NotDone;
class Standard_NumericError;
class math_FunctionWithDerivative;
class math_FunctionSample;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! This algorithm uses a sample of the function to find <br>
//!          all intervals on which the function is null, and afterwards <br>
//!          uses the FunctionRoots algorithm to find the points <br>
//!          where the function is null outside the "null intervals". <br>
//! Knowledge of the derivative is required. <br>
class math_FunctionAllRoots  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! The algorithm uses the sample to find intervals on which <br>
//!          the function is null. An interval is found if, for at least <br>
//!          two consecutive points of the sample, Ui and Ui+1, we get <br>
//!          |F(Ui)|<=EpsNul and |F(Ui+1)|<=EpsNul. The real bounds of <br>
//!          an interval are computed with the FunctionRoots. <br>
//!          algorithm. <br>
//!          Between two intervals, the roots of the function F are <br>
//!          calculated using the FunctionRoots algorithm. <br>
Standard_EXPORT math_FunctionAllRoots(math_FunctionWithDerivative& F,const math_FunctionSample& S,const Standard_Real EpsX,const Standard_Real EpsF,const Standard_Real EpsNul);
//! Returns True if the computation has been done successfully. <br>
  Standard_Boolean IsDone() const;
//! Returns the number of intervals on which the function <br>
//!          is Null. <br>
//!          An exception is raised if IsDone returns False. <br>
  Standard_Integer NbIntervals() const;
//! Returns the interval of parameter of range Index. <br>
//!          An exception is raised if IsDone returns False; <br>
//!          An exception is raised if Index<=0 or Index >Nbintervals. <br>
  void GetInterval(const Standard_Integer Index,Standard_Real& A,Standard_Real& B) const;
//! returns the State Number associated to the interval Index. <br>
//!          An exception is raised if IsDone returns False; <br>
//!          An exception is raised if Index<=0 or Index >Nbintervals. <br>
  void GetIntervalState(const Standard_Integer Index,Standard_Integer& IFirst,Standard_Integer& ILast) const;
//! returns the number of points where the function is Null. <br>
//!          An exception is raised if IsDone returns False. <br>
  Standard_Integer NbPoints() const;
//! Returns the parameter of the point of range Index. <br>
//!          An exception is raised if IsDone returns False; <br>
//!          An exception is raised if Index<=0 or Index >NbPoints. <br>
  Standard_Real GetPoint(const Standard_Integer Index) const;
//! returns the State Number associated to the point Index. <br>
//!          An exception is raised if IsDone returns False; <br>
//!          An exception is raised if Index<=0 or Index >Nbintervals. <br>
  Standard_Integer GetPointState(const Standard_Integer Index) const;

//! Prints on the stream o information on the current state <br>
//!          of the object. <br>
Standard_EXPORT   void Dump(Standard_OStream& o) const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Standard_Boolean done;
TColStd_SequenceOfReal pdeb;
TColStd_SequenceOfReal pfin;
TColStd_SequenceOfReal piso;
TColStd_SequenceOfInteger ideb;
TColStd_SequenceOfInteger ifin;
TColStd_SequenceOfInteger iiso;


};


#include <math_FunctionAllRoots.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
