// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _gce_MakeLin_HeaderFile
#define _gce_MakeLin_HeaderFile

#ifndef _gp_Lin_HeaderFile
#include <gp_Lin.hxx>
#endif
#ifndef _gce_Root_HeaderFile
#include <gce_Root.hxx>
#endif
class StdFail_NotDone;
class gp_Ax1;
class gp_Pnt;
class gp_Dir;
class gp_Lin;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! This class implements the following algorithms used <br>
//!           to create a Lin from gp. <br>
//!           * Create a Lin parallel to another and passing <br>
//!             through a point. <br>
//!           * Create a Lin passing through 2 points. <br>
//!           * Create a lin from its axis (Ax1 from gp). <br>
//!           * Create a lin from a point and a direction. <br>
class gce_MakeLin  : public gce_Root {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Creates a line located along the axis A1. <br>
Standard_EXPORT gce_MakeLin(const gp_Ax1& A1);


//!  <P> is the location point (origin) of the line and <br>
//!  <V> is the direction of the line. <br>
Standard_EXPORT gce_MakeLin(const gp_Pnt& P,const gp_Dir& V);

//! Make a Lin from gp <TheLin> parallel to another <br>
//!           Lin <Lin> and passing through a Pnt <Point>. <br>
Standard_EXPORT gce_MakeLin(const gp_Lin& Lin,const gp_Pnt& Point);

//! Make a Lin from gp <TheLin> passing through 2 <br>
//!           Pnt <P1>,<P2>. <br>
//!           It returns false if <p1> and <P2> are confused. <br>
Standard_EXPORT gce_MakeLin(const gp_Pnt& P1,const gp_Pnt& P2);

//! Returns the constructed line. <br>
//! Exceptions StdFail_NotDone is raised if no line is constructed. <br>
Standard_EXPORT  const gp_Lin& Value() const;


Standard_EXPORT  const gp_Lin& Operator() const;
Standard_EXPORT operator gp_Lin() const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
gp_Lin TheLin;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
