// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _gce_MakeElips_HeaderFile
#define _gce_MakeElips_HeaderFile

#ifndef _gp_Elips_HeaderFile
#include <gp_Elips.hxx>
#endif
#ifndef _gce_Root_HeaderFile
#include <gce_Root.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
class StdFail_NotDone;
class gp_Ax2;
class gp_Pnt;
class gp_Elips;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//!This class implements the following algorithms used to <br>
//!          create an ellipse from gp. <br>
//! <br>
//!          * Create an ellipse from its center, and two points: <br>
//!            one on the ciconference giving the major radius, the <br>
//!            other giving the value of the small radius. <br>
class gce_MakeElips  : public gce_Root {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//!The major radius of the ellipse is on the "XAxis" and the <br>
//!           minor radius is on the "YAxis" of the ellipse. The "XAxis" <br>
//!           is defined with the "XDirection" of A2 and the "YAxis" is <br>
//!           defined with the "YDirection" of A2. <br>
//! Warnings : <br>
//!           It is not forbidden to create an ellipse with <br>
//!           MajorRadius = MinorRadius. <br>
Standard_EXPORT gce_MakeElips(const gp_Ax2& A2,const Standard_Real MajorRadius,const Standard_Real MinorRadius);

//! Make an ellipse with its center and two points. <br>
//! Warning <br>
//! The MakeElips class does not prevent the <br>
//! construction of an ellipse where the MajorRadius is <br>
//! equal to the MinorRadius. <br>
//! If an error occurs (that is, when IsDone returns <br>
//! false), the Status function returns: <br>
//! -   gce_InvertRadius if MajorRadius is less than MinorRadius; <br>
//! -   gce_NegativeRadius if MinorRadius is less than 0.0; <br>
//! -   gce_NullAxis if the points S1 and Center are coincident; or <br>
//! -   gce_InvertAxis if: <br>
//!   -   the major radius computed with Center and S1 <br>
//!    is less than the minor radius computed with Center, S1 and S2, or <br>
//!   -   Center, S1 and S2 are collinear. <br>
Standard_EXPORT gce_MakeElips(const gp_Pnt& S1,const gp_Pnt& S2,const gp_Pnt& Center);

//! Returns the constructed ellipse. <br>
//! Exceptions StdFail_NotDone if no ellipse is constructed. <br>
Standard_EXPORT  const gp_Elips& Value() const;


Standard_EXPORT  const gp_Elips& Operator() const;
Standard_EXPORT operator gp_Elips() const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
gp_Elips TheElips;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
