// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Vrml_MatrixTransform_HeaderFile
#define _Vrml_MatrixTransform_HeaderFile

#ifndef _gp_Trsf_HeaderFile
#include <gp_Trsf.hxx>
#endif
#ifndef _Standard_OStream_HeaderFile
#include <Standard_OStream.hxx>
#endif
class gp_Trsf;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! defines a MatrixTransform node of VRML specifying matrix and transform <br>
//!          properties. <br>
//!  This  node  defines  3D  transformation  with  a  4  by  4  matrix. <br>
//!  By  default  : <br>
//!  a11=1  a12=0  a13=0  a14=0 <br>
//!  a21=0  a22=1  a23=0  a24=0 <br>
//!  a31=0  a32=0  a33=1  a34=0 <br>
//!  a41=0  a42=0  a43=0  a44=1 <br>
//!  It  is  written  to  the  file  in  row-major  order  as  16  Real numbers <br>
//!  separated  by  whitespace.  For  example ,  matrix  expressing  a  translation <br>
//!  of  7.3  units  along  the  X  axis  is  written  as: <br>
//!  1  0  0  0   0  1  0  0   0  0  1  0   7.3 0  0  1 <br>
class Vrml_MatrixTransform  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


Standard_EXPORT Vrml_MatrixTransform();


Standard_EXPORT Vrml_MatrixTransform(const gp_Trsf& aMatrix);


Standard_EXPORT   void SetMatrix(const gp_Trsf& aMatrix) ;


Standard_EXPORT   gp_Trsf Matrix() const;


Standard_EXPORT   Standard_OStream& Print(Standard_OStream& anOStream) const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
gp_Trsf myMatrix;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
