// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Visual3d_ContextPick_HeaderFile
#define _Visual3d_ContextPick_HeaderFile

#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Visual3d_TypeOfOrder_HeaderFile
#include <Visual3d_TypeOfOrder.hxx>
#endif
class Visual3d_ContextPickDefinitionError;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! This class allows the creation and update of <br>
//!	    a pick context for one view of the viewer. <br>
//!	    A context allows the control of different parameters <br>
//!	    before the activation of a pick. <br>
class Visual3d_ContextPick  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Creates a context from default values <br>
Standard_EXPORT Visual3d_ContextPick();

//! Creates a context with the values defined <br>
//!  Warning: Raises ContextPickDefinitionError if <Depth> or <br>
//!	    <Aperture> is a negative value. <br>
Standard_EXPORT Visual3d_ContextPick(const Standard_Real Aperture,const Standard_Integer Depth,const Visual3d_TypeOfOrder Order);

//! Modifies the size of the pick window. <br>
//!  Category: Methods to modifies the class definition <br>
//!  Warning: Raises ContextPickDefinitionError if <Aperture> is <br>
//!	    a negative value. <br>
Standard_EXPORT   void SetAperture(const Standard_Real Aperture) ;

//! Modifies the pick depth a priori. <br>
//!  Category: Methods to modifies the class definition <br>
//!  Warning: Raises ContextPickDefinitionError if <Depth> is <br>
//!	    a negative value. <br>
Standard_EXPORT   void SetDepth(const Standard_Integer Depth) ;

//! Modifies the order of picking. <br>
Standard_EXPORT   void SetOrder(const Visual3d_TypeOfOrder Order) ;

//! Returns the size of the pick window <me>. <br>
Standard_EXPORT   Standard_Real Aperture() const;

//! Returns the effective pick depth of <me>. <br>
Standard_EXPORT   Standard_Integer Depth() const;

//! Returns the order of picking of <me>. <br>
Standard_EXPORT   Visual3d_TypeOfOrder Order() const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Standard_Real MyAperture;
Standard_Integer MyDepth;
Visual3d_TypeOfOrder MyOrder;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
