// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Units_Explorer_HeaderFile
#define _Units_Explorer_HeaderFile

#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Handle_Units_QuantitiesSequence_HeaderFile
#include <Handle_Units_QuantitiesSequence.hxx>
#endif
#ifndef _Handle_Units_UnitsSequence_HeaderFile
#include <Handle_Units_UnitsSequence.hxx>
#endif
#ifndef _Handle_TColStd_HSequenceOfInteger_HeaderFile
#include <Handle_TColStd_HSequenceOfInteger.hxx>
#endif
#ifndef _Handle_Units_UnitsSystem_HeaderFile
#include <Handle_Units_UnitsSystem.hxx>
#endif
#ifndef _Handle_Units_UnitsDictionary_HeaderFile
#include <Handle_Units_UnitsDictionary.hxx>
#endif
#ifndef _Standard_CString_HeaderFile
#include <Standard_CString.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
class Units_QuantitiesSequence;
class Units_UnitsSequence;
class TColStd_HSequenceOfInteger;
class Units_UnitsSystem;
class Units_UnitsDictionary;
class TCollection_AsciiString;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! This class provides all the services to explore <br>
//!          UnitsSystem or UnitsDictionary. <br>
class Units_Explorer  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Empty contructor of the class. <br>
Standard_EXPORT Units_Explorer();

//! Creates a new instance of the class, initialized with <br>
//!          the UnitsSystem <aunitssystem>. <br>
Standard_EXPORT Units_Explorer(const Handle(Units_UnitsSystem)& aunitssystem);

//! Creates a new instance of the class, initialized with <br>
//!          the UnitsDictionary <aunitsdictionary>. <br>
Standard_EXPORT Units_Explorer(const Handle(Units_UnitsDictionary)& aunitsdictionary);

//! Creates a new instance of the class, initialized with <br>
//!          the UnitsSystem <aunitssystem> and positioned at the <br>
//!          quantity <aquantity>. <br>
Standard_EXPORT Units_Explorer(const Handle(Units_UnitsSystem)& aunitssystem,const Standard_CString aquantity);

//! Creates a  new instance of the class,  initialized with <br>
//!          the  UnitsDictionary <aunitsdictionary> and positioned <br>
//!          at the quantity <aquantity>. <br>
Standard_EXPORT Units_Explorer(const Handle(Units_UnitsDictionary)& aunitsdictionary,const Standard_CString aquantity);

//! Initializes  the  instance  of  the  class  with  the <br>
//!          UnitsSystem <aunitssystem>. <br>
Standard_EXPORT   void Init(const Handle(Units_UnitsSystem)& aunitssystem) ;

//! Initializes  the  instance  of  the  class  with  the <br>
//!          UnitsDictionary <aunitsdictionary>. <br>
Standard_EXPORT   void Init(const Handle(Units_UnitsDictionary)& aunitsdictionary) ;

//! Initializes  the  instance  of  the   class  with  the <br>
//!          UnitsSystem  <aunitssystem>  and   positioned  at  the <br>
//!          quantity <aquantity>. <br>
Standard_EXPORT   void Init(const Handle(Units_UnitsSystem)& aunitssystem,const Standard_CString aquantity) ;

//! Initializes  the  instance   of  the  class  with  the <br>
//!          UnitsDictionary  <aunitsdictionary> and positioned  at <br>
//!          the quantity <aquantity>. <br>
Standard_EXPORT   void Init(const Handle(Units_UnitsDictionary)& aunitsdictionary,const Standard_CString aquantity) ;

//! Returns True if there is another Quantity to explore, <br>
//!          False otherwise. <br>
Standard_EXPORT   Standard_Boolean MoreQuantity() const;

//! Sets the next Quantity current. <br>
Standard_EXPORT   void NextQuantity() ;

//! Returns the name of the current Quantity. <br>
Standard_EXPORT   TCollection_AsciiString Quantity() const;

//! Returns True if there is another Unit to explore, <br>
//!          False otherwise. <br>
Standard_EXPORT   Standard_Boolean MoreUnit() const;

//! Sets the next Unit current. <br>
Standard_EXPORT   void NextUnit() ;

//! Returns the name of the current unit. <br>
Standard_EXPORT   TCollection_AsciiString Unit() const;

//! If the  units system  to  explore  is  a user  system, <br>
//!          returns True  if  the  current unit  is  active, False <br>
//!          otherwise. <br>
//! <br>
//!          If   the   units  system  to  explore  is   the  units <br>
//!          dictionary,  returns True if the  current unit is  the <br>
//!          S.I. unit. <br>
Standard_EXPORT   Standard_Boolean IsActive() const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Standard_Integer thecurrentquantity;
Handle_Units_QuantitiesSequence thequantitiessequence;
Standard_Integer thecurrentunit;
Handle_Units_UnitsSequence theunitssequence;
Handle_TColStd_HSequenceOfInteger theactiveunitssequence;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
