// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _TopOpeBRepDS_HDataStructure_HeaderFile
#define _TopOpeBRepDS_HDataStructure_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_TopOpeBRepDS_HDataStructure_HeaderFile
#include <Handle_TopOpeBRepDS_HDataStructure.hxx>
#endif

#ifndef _TopOpeBRepDS_DataStructure_HeaderFile
#include <TopOpeBRepDS_DataStructure.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _TCollection_AsciiString_HeaderFile
#include <TCollection_AsciiString.hxx>
#endif
#ifndef _MMgt_TShared_HeaderFile
#include <MMgt_TShared.hxx>
#endif
#ifndef _TopAbs_ShapeEnum_HeaderFile
#include <TopAbs_ShapeEnum.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _TopOpeBRepDS_Config_HeaderFile
#include <TopOpeBRepDS_Config.hxx>
#endif
#ifndef _TopOpeBRepDS_Kind_HeaderFile
#include <TopOpeBRepDS_Kind.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Handle_TopOpeBRepDS_Interference_HeaderFile
#include <Handle_TopOpeBRepDS_Interference.hxx>
#endif
class TopoDS_Shape;
class TopOpeBRepDS_DataStructure;
class TopOpeBRepDS_Surface;
class TopOpeBRepDS_CurveIterator;
class TopOpeBRepDS_Curve;
class TopOpeBRepDS_PointIterator;
class TopOpeBRepDS_Point;
class TopTools_ListIteratorOfListOfShape;
class TopOpeBRepDS_SurfaceIterator;
class TopOpeBRepDS_ListOfInterference;
class TopOpeBRepDS_ListIteratorOfListOfInterference;
class TopOpeBRepDS_Interference;



class TopOpeBRepDS_HDataStructure : public MMgt_TShared {

public:
 // Methods PUBLIC
 // 


Standard_EXPORT TopOpeBRepDS_HDataStructure();


Standard_EXPORT   void AddAncestors(const TopoDS_Shape& S) ;

//! Update  the data structure with  shapes of type T1 <br>
//!          containing a subshape of type T2 which is stored <br>
//!          in the DS. <br>
//!          Used by the previous one. <br>
Standard_EXPORT   void AddAncestors(const TopoDS_Shape& S,const TopAbs_ShapeEnum T1,const TopAbs_ShapeEnum T2) ;

//! perform post processing of the DS. <br>
Standard_EXPORT   void Complete() ;

//! Check l'integrit de la DS <br>
Standard_EXPORT   void ChkIntg() ;


Standard_EXPORT  const TopOpeBRepDS_DataStructure& DS() const;


Standard_EXPORT   TopOpeBRepDS_DataStructure& ChangeDS() ;


Standard_EXPORT   Standard_Integer NbSurfaces() const;


Standard_EXPORT   Standard_Integer NbCurves() const;


Standard_EXPORT   Standard_Integer NbPoints() const;

//! Returns the surface of index <I>. <br>
Standard_EXPORT  const TopOpeBRepDS_Surface& Surface(const Standard_Integer I) const;

//! Returns an iterator  on the curves on  the surface <br>
//!          <I>. <br>
Standard_EXPORT   TopOpeBRepDS_CurveIterator SurfaceCurves(const Standard_Integer I) const;

//! Returns the Curve of index <I>. <br>
Standard_EXPORT  const TopOpeBRepDS_Curve& Curve(const Standard_Integer I) const;

//! Returns the Curve of index <I>. <br>
//! <br>
Standard_EXPORT   TopOpeBRepDS_Curve& ChangeCurve(const Standard_Integer I) ;

//! Returns an iterator   on the points on  the  curve <br>
//!          <I>. <br>
Standard_EXPORT   TopOpeBRepDS_PointIterator CurvePoints(const Standard_Integer I) const;

//! Returns the point of index <I>. <br>
Standard_EXPORT  const TopOpeBRepDS_Point& Point(const Standard_Integer I) const;


Standard_EXPORT   Standard_Integer NbShapes() const;

//! Returns the shape of index <I> in the DS <br>
Standard_EXPORT  const TopoDS_Shape& Shape(const Standard_Integer I,const Standard_Boolean FindKeep = Standard_True) const;

//! Returns the index of shape <S> in the DS <br>
//!          returns 0 if <S> is not in the DS <br>
Standard_EXPORT   Standard_Integer Shape(const TopoDS_Shape& S,const Standard_Boolean FindKeep = Standard_True) const;

//! Returns True if <S> has new geometries. <br>
Standard_EXPORT   Standard_Boolean HasGeometry(const TopoDS_Shape& S) const;

//! Returns True if <S> has new geometries (SOLID,FACE,EDGE) <br>
//!          or if <S> (SHELL,WIRE) has sub-shape (FACE,EDGE) <br>
//!          with new geometries <br>
Standard_EXPORT   Standard_Boolean HasShape(const TopoDS_Shape& S,const Standard_Boolean FindKeep = Standard_True) const;

//! Returns True if <S> share a geometrical domain with <br>
//!          some other shapes. <br>
Standard_EXPORT   Standard_Boolean HasSameDomain(const TopoDS_Shape& S,const Standard_Boolean FindKeep = Standard_True) const;

//! Returns an iterator on the SameDomain shapes attached <br>
//!          to the shape <S>. <br>
Standard_EXPORT   TopTools_ListIteratorOfListOfShape SameDomain(const TopoDS_Shape& S) const;

//! Returns orientation of shape <S> compared with its <br>
//!          reference shape <br>
Standard_EXPORT   TopOpeBRepDS_Config SameDomainOrientation(const TopoDS_Shape& S) const;

//! Returns orientation of shape <S> compared with its <br>
//!          reference shape <br>
Standard_EXPORT   Standard_Integer SameDomainReference(const TopoDS_Shape& S) const;

//! Returns an iterator on the  surfaces attached to the <br>
//!          solid <S>. <br>
Standard_EXPORT   TopOpeBRepDS_SurfaceIterator SolidSurfaces(const TopoDS_Shape& S) const;

//! Returns an iterator on the  surfaces attached to the <br>
//!          solid <I>. <br>
Standard_EXPORT   TopOpeBRepDS_SurfaceIterator SolidSurfaces(const Standard_Integer I) const;

//! Returns an iterator on the  curves attached to the <br>
//!          face <F>. <br>
Standard_EXPORT   TopOpeBRepDS_CurveIterator FaceCurves(const TopoDS_Shape& F) const;

//! Returns an iterator on the  curves attached to the <br>
//!          face <I>. <br>
Standard_EXPORT   TopOpeBRepDS_CurveIterator FaceCurves(const Standard_Integer I) const;

//! Returns an iterator on the points  attached to the <br>
//!          edge <E>. <br>
Standard_EXPORT   TopOpeBRepDS_PointIterator EdgePoints(const TopoDS_Shape& E) const;


Standard_EXPORT   Standard_Integer MakeCurve(const TopOpeBRepDS_Curve& C1,TopOpeBRepDS_Curve& C2) ;


Standard_EXPORT   void RemoveCurve(const Standard_Integer iC) ;


Standard_EXPORT   void RemoveShape(const Standard_Integer iS) ;


Standard_EXPORT   Standard_Integer NbGeometry(const TopOpeBRepDS_Kind K) const;


Standard_EXPORT   Standard_Integer NbTopology(const TopOpeBRepDS_Kind K) const;


Standard_EXPORT   Standard_Integer NbTopology() const;

//! returns True if all the edges stored as shapes in the DS <br>
//!          are SameParameter, otherwise False. <br>
Standard_EXPORT   Standard_Boolean EdgesSameParameter() const;


Standard_EXPORT   void SortOnParameter(const TopOpeBRepDS_ListOfInterference& L1,TopOpeBRepDS_ListOfInterference& L2) const;


Standard_EXPORT   void SortOnParameter(TopOpeBRepDS_ListOfInterference& L) const;


Standard_EXPORT   void MinMaxOnParameter(const TopOpeBRepDS_ListOfInterference& L,Standard_Real& Min,Standard_Real& Max) const;


//! Search, among a list of interferences accessed by the iterator <br>
//! <IT>, a geometry <G> whose 3D point is identical to the 3D point <br>
//! of the TheDSPoint <PDS>. <br>
//! returns True if such an interference has been found, False else. <br>
//! if True, iterator It points (by the Value() method) on the first <br>
//! interference accessing an identical 3D point. <br>
Standard_EXPORT   Standard_Boolean ScanInterfList(TopOpeBRepDS_ListIteratorOfListOfInterference& IT,const TopOpeBRepDS_Point& PDS) const;


//! Get the geometry of a DS point <PDS>. <br>
//! Search for it with ScanInterfList (previous method). <br>
//! if found, set <G,K> to the geometry,kind of the interference found. <br>
//! returns the value of ScanInterfList(). <br>
Standard_EXPORT   Standard_Boolean GetGeometry(TopOpeBRepDS_ListIteratorOfListOfInterference& IT,const TopOpeBRepDS_Point& PDS,Standard_Integer& G,TopOpeBRepDS_Kind& K) const;


//! Add interference <I> to list <LI>. <br>
Standard_EXPORT   void StoreInterference(const Handle(TopOpeBRepDS_Interference)& I,TopOpeBRepDS_ListOfInterference& LI,const TCollection_AsciiString& str = "") ;


//! Add interference <I> to list of interference of shape <S>. <br>
Standard_EXPORT   void StoreInterference(const Handle(TopOpeBRepDS_Interference)& I,const TopoDS_Shape& S,const TCollection_AsciiString& str = "") ;


//! Add interference <I> to list of interference of shape <IS>. <br>
Standard_EXPORT   void StoreInterference(const Handle(TopOpeBRepDS_Interference)& I,const Standard_Integer IS,const TCollection_AsciiString& str = "") ;


Standard_EXPORT   void StoreInterferences(const TopOpeBRepDS_ListOfInterference& LI,const TopoDS_Shape& S,const TCollection_AsciiString& str = "") ;


Standard_EXPORT   void StoreInterferences(const TopOpeBRepDS_ListOfInterference& LI,const Standard_Integer IS,const TCollection_AsciiString& str = "") ;


Standard_EXPORT   void ClearStoreInterferences(const TopOpeBRepDS_ListOfInterference& LI,const TopoDS_Shape& S,const TCollection_AsciiString& str = "") ;


Standard_EXPORT   void ClearStoreInterferences(const TopOpeBRepDS_ListOfInterference& LI,const Standard_Integer IS,const TCollection_AsciiString& str = "") ;
//Standard_EXPORT ~TopOpeBRepDS_HDataStructure();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
TopOpeBRepDS_DataStructure myDS;
Standard_Boolean myEdgesSameParameter;
TCollection_AsciiString myAscii;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
