// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _TopOpeBRepDS_Check_HeaderFile
#define _TopOpeBRepDS_Check_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_TopOpeBRepDS_Check_HeaderFile
#include <Handle_TopOpeBRepDS_Check.hxx>
#endif

#ifndef _Handle_TopOpeBRepDS_HDataStructure_HeaderFile
#include <Handle_TopOpeBRepDS_HDataStructure.hxx>
#endif
#ifndef _TopOpeBRepDS_DataMapOfCheckStatus_HeaderFile
#include <TopOpeBRepDS_DataMapOfCheckStatus.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _MMgt_TShared_HeaderFile
#include <MMgt_TShared.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _TopOpeBRepDS_Kind_HeaderFile
#include <TopOpeBRepDS_Kind.hxx>
#endif
#ifndef _Standard_OStream_HeaderFile
#include <Standard_OStream.hxx>
#endif
#ifndef _Standard_CString_HeaderFile
#include <Standard_CString.hxx>
#endif
#ifndef _TopOpeBRepDS_CheckStatus_HeaderFile
#include <TopOpeBRepDS_CheckStatus.hxx>
#endif
#ifndef _TopAbs_ShapeEnum_HeaderFile
#include <TopAbs_ShapeEnum.hxx>
#endif
class TopOpeBRepDS_HDataStructure;
class TopOpeBRepDS_ListOfInterference;
class TopTools_ListOfShape;
class TopOpeBRepDS_DataMapOfCheckStatus;


//! a tool verifing integrity and structure of DS <br>
class TopOpeBRepDS_Check : public MMgt_TShared {

public:
 // Methods PUBLIC
 // 


Standard_EXPORT TopOpeBRepDS_Check();


Standard_EXPORT TopOpeBRepDS_Check(const Handle(TopOpeBRepDS_HDataStructure)& HDS);

//! Check l'integrit de la DS <br>
Standard_EXPORT   Standard_Boolean ChkIntg() ;

//! Check l'integrit des interfrences <br>
//!          (les supports et les gomtries de LI) <br>
Standard_EXPORT   Standard_Boolean ChkIntgInterf(const TopOpeBRepDS_ListOfInterference& LI) ;

//! Vrifie que le ime lment de la DS existe, et <br>
//!          pour un K de type topologique, vrifie qu'il est du <br>
//!          bon type (VERTEX, EDGE, WIRE, FACE, SHELL ou SOLID) <br>
Standard_EXPORT   Standard_Boolean CheckDS(const Standard_Integer i,const TopOpeBRepDS_Kind K) ;

//! Check l'integrit des champs SameDomain de la DS <br>
Standard_EXPORT   Standard_Boolean ChkIntgSamDom() ;

//! Vrifie que les Shapes existent bien dans la DS <br>
//!          Utile pour les Shapes SameDomain <br>
//!          si la liste est vide, renvoie vrai <br>
Standard_EXPORT   Standard_Boolean CheckShapes(const TopTools_ListOfShape& LS) const;

//!    Vrifie que les Vertex   non   SameDomain sont bien <br>
//!           nonSameDomain, que  les  vertex sameDomain sont  bien <br>
//!          SameDomain,  que    les  Points sont  non    confondus <br>
//!           ni entre eux, ni avec des Vertex. <br>
Standard_EXPORT   Standard_Boolean OneVertexOnPnt() ;


Standard_EXPORT  const Handle_TopOpeBRepDS_HDataStructure& HDS() const;


Standard_EXPORT   Handle_TopOpeBRepDS_HDataStructure& ChangeHDS() ;


Standard_EXPORT   Standard_OStream& PrintIntg(Standard_OStream& S) ;

//! Prints the name  of CheckStatus  <stat>  as  a String <br>
Standard_EXPORT   Standard_OStream& Print(const TopOpeBRepDS_CheckStatus stat,Standard_OStream& S) ;

//! Prints the name  of CheckStatus  <stat>  as  a String <br>
Standard_EXPORT   Standard_OStream& PrintShape(const TopAbs_ShapeEnum SE,Standard_OStream& S) ;

//! Prints the name  of CheckStatus  <stat>  as  a String <br>
Standard_EXPORT   Standard_OStream& PrintShape(const Standard_Integer index,Standard_OStream& S) ;
//Standard_EXPORT ~TopOpeBRepDS_Check();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


Standard_EXPORT   Standard_OStream& PrintMap(TopOpeBRepDS_DataMapOfCheckStatus& MapStat,const Standard_CString eltstr,Standard_OStream& S) ;


Standard_EXPORT   Standard_OStream& PrintElts(TopOpeBRepDS_DataMapOfCheckStatus& MapStat,const TopOpeBRepDS_CheckStatus Stat,Standard_Boolean& b,Standard_OStream& S) ;


 // Fields PRIVATE
 //
Handle_TopOpeBRepDS_HDataStructure myHDS;
TopOpeBRepDS_DataMapOfCheckStatus myMapSurfaceStatus;
Standard_Boolean mySurfaceDone;
TopOpeBRepDS_DataMapOfCheckStatus myMapCurveStatus;
Standard_Boolean myCurveDone;
TopOpeBRepDS_DataMapOfCheckStatus myMapPointStatus;
Standard_Boolean myPointDone;
TopOpeBRepDS_DataMapOfCheckStatus myMapShapeStatus;
Standard_Boolean myShapeDone;
Standard_Boolean myDone;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
