// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _ShapeUpgrade_RemoveLocations_HeaderFile
#define _ShapeUpgrade_RemoveLocations_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_ShapeUpgrade_RemoveLocations_HeaderFile
#include <Handle_ShapeUpgrade_RemoveLocations.hxx>
#endif

#ifndef _TopAbs_ShapeEnum_HeaderFile
#include <TopAbs_ShapeEnum.hxx>
#endif
#ifndef _TopoDS_Shape_HeaderFile
#include <TopoDS_Shape.hxx>
#endif
#ifndef _TopTools_DataMapOfShapeShape_HeaderFile
#include <TopTools_DataMapOfShapeShape.hxx>
#endif
#ifndef _MMgt_TShared_HeaderFile
#include <MMgt_TShared.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
class TopoDS_Shape;


//! Removes all locations sub-shapes of specified shape <br>
class ShapeUpgrade_RemoveLocations : public MMgt_TShared {

public:
 // Methods PUBLIC
 // 

//!Empy constructor <br>
Standard_EXPORT ShapeUpgrade_RemoveLocations();

//!Removes all location correspodingly to RemoveLevel. <br>
Standard_EXPORT   Standard_Boolean Remove(const TopoDS_Shape& theShape) ;
//!Returns shape with removed locatins. <br>
  TopoDS_Shape GetResult() const;
//!sets level starting with that location will be removed, <br>
//!         by default TopAbs_SHAPE. In this case locations will be kept for specified shape <br>
//!         and if specified shape is TopAbs_COMPOUND for sub-shapes of first level. <br>
  void SetRemoveLevel(const TopAbs_ShapeEnum theLevel) ;
//!sets level starting with that location will be removed.Value of level can be set to <br>
//!         TopAbs_SHAPE,TopAbs_COMPOUND,TopAbs_SOLID,TopAbs_SHELL,TopAbs_FACE.By default TopAbs_SHAPE. <br>
//!         In this case location will be removed for all shape types for exception of compound. <br>
  TopAbs_ShapeEnum RemoveLevel() const;
//! Returns modified shape obtained from initial shape. <br>
  TopoDS_Shape ModifiedShape(const TopoDS_Shape& theInitShape) const;
//Standard_EXPORT ~ShapeUpgrade_RemoveLocations();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


Standard_EXPORT   Standard_Boolean MakeNewShape(const TopoDS_Shape& theShape,const TopoDS_Shape& theAncShape,TopoDS_Shape& theNewShape,const Standard_Boolean theRemoveLoc) ;


 // Fields PRIVATE
 //
TopAbs_ShapeEnum myLevelRemoving;
TopoDS_Shape myShape;
TopTools_DataMapOfShapeShape myMapNewShapes;


};


#include <ShapeUpgrade_RemoveLocations.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
