// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _ShapeExtend_HeaderFile
#define _ShapeExtend_HeaderFile

#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _ShapeExtend_Status_HeaderFile
#include <ShapeExtend_Status.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
class ShapeExtend_ComplexCurve;
class ShapeExtend_CompositeSurface;
class ShapeExtend_WireData;
class ShapeExtend_BasicMsgRegistrator;
class ShapeExtend_MsgRegistrator;
class ShapeExtend_Explorer;
class ShapeExtend_DataMapOfShapeListOfMsg;
class ShapeExtend_DataMapOfTransientListOfMsg;
class ShapeExtend_DataMapNodeOfDataMapOfShapeListOfMsg;
class ShapeExtend_DataMapIteratorOfDataMapOfShapeListOfMsg;
class ShapeExtend_DataMapNodeOfDataMapOfTransientListOfMsg;
class ShapeExtend_DataMapIteratorOfDataMapOfTransientListOfMsg;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! This package provides general tools and data structures common <br>
//!	        for other packages in SHAPEWORKS and extending CAS.CADE <br>
//!          structures. <br>
//!          The following items are provided by this package: <br>
//!          - enumeration Status used for coding status flags in methods <br>
//!            inside the SHAPEWORKS <br>
//!          - enumeration Parametrisation used for setting global parametrisation <br>
//!            on the composite surface <br>
//!          - class CompositeSurface representing a composite surface <br>
//!            made of a grid of surface patches <br>
//!          - class WireData representing a wire in the form of ordered <br>
//!            list of edges <br>
//!          - class MsgRegistrator for attaching messages to the objects <br>
//!          - tools for exploring the shapes <br>
//! -       tools for creating       new shapes. <br>
class ShapeExtend  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Inits using of ShapeExtend. <br>
//!          Currently, loads messages output by ShapeHealing algorithms. <br>
Standard_EXPORT static  void Init() ;

//! Encodes status (enumeration) to a bit flag <br>
Standard_EXPORT static  Standard_Integer EncodeStatus(const ShapeExtend_Status status) ;

//! Tells if a bit flag contains bit corresponding to enumerated status <br>
Standard_EXPORT static  Standard_Boolean DecodeStatus(const Standard_Integer flag,const ShapeExtend_Status status) ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //

friend class ShapeExtend_ComplexCurve;
friend class ShapeExtend_CompositeSurface;
friend class ShapeExtend_WireData;
friend class ShapeExtend_BasicMsgRegistrator;
friend class ShapeExtend_MsgRegistrator;
friend class ShapeExtend_Explorer;
friend class ShapeExtend_DataMapOfShapeListOfMsg;
friend class ShapeExtend_DataMapOfTransientListOfMsg;
friend class ShapeExtend_DataMapNodeOfDataMapOfShapeListOfMsg;
friend class ShapeExtend_DataMapIteratorOfDataMapOfShapeListOfMsg;
friend class ShapeExtend_DataMapNodeOfDataMapOfTransientListOfMsg;
friend class ShapeExtend_DataMapIteratorOfDataMapOfTransientListOfMsg;

};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
