// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _ShapeConstruct_CompBezierCurves2dToBSplineCurve2d_HeaderFile
#define _ShapeConstruct_CompBezierCurves2dToBSplineCurve2d_HeaderFile

#ifndef _Convert_SequenceOfArray1OfPoles2d_HeaderFile
#include <Convert_SequenceOfArray1OfPoles2d.hxx>
#endif
#ifndef _TColgp_SequenceOfPnt2d_HeaderFile
#include <TColgp_SequenceOfPnt2d.hxx>
#endif
#ifndef _TColStd_SequenceOfReal_HeaderFile
#include <TColStd_SequenceOfReal.hxx>
#endif
#ifndef _TColStd_SequenceOfInteger_HeaderFile
#include <TColStd_SequenceOfInteger.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
class Standard_ConstructionError;
class TColgp_Array1OfPnt2d;
class TColStd_Array1OfReal;
class TColStd_Array1OfInteger;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Converts a list  of connecting Bezier Curves 2d to  a <br>
//!          BSplineCurve 2d. <br>
//!          if possible, the continuity of the BSpline will be <br>
//!          increased to more than C0. <br>
class ShapeConstruct_CompBezierCurves2dToBSplineCurve2d  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


Standard_EXPORT ShapeConstruct_CompBezierCurves2dToBSplineCurve2d(const Standard_Real AngularTolerance = 1.0e-4);


Standard_EXPORT   void AddCurve(const TColgp_Array1OfPnt2d& Poles) ;

//! Computes the algorithm. <br>
Standard_EXPORT   void Perform() ;


Standard_EXPORT   Standard_Integer Degree() const;


Standard_EXPORT   Standard_Integer NbPoles() const;


Standard_EXPORT   void Poles(TColgp_Array1OfPnt2d& Poles) const;


Standard_EXPORT   Standard_Integer NbKnots() const;


Standard_EXPORT   void KnotsAndMults(TColStd_Array1OfReal& Knots,TColStd_Array1OfInteger& Mults) const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Convert_SequenceOfArray1OfPoles2d mySequence;
TColgp_SequenceOfPnt2d CurvePoles;
TColStd_SequenceOfReal CurveKnots;
TColStd_SequenceOfInteger KnotsMultiplicities;
Standard_Integer myDegree;
Standard_Real myAngular;
Standard_Boolean myDone;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
