// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Poly_Triangle_HeaderFile
#define _Poly_Triangle_HeaderFile

#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
class Standard_OutOfRange;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Describes a component triangle of a triangulation <br>
//! (Poly_Triangulation object). <br>
//! A Triangle is defined by a triplet of nodes. Each node is an <br>
//! index in the table of nodes specific to an existing <br>
//! triangulation of a shape, and represents a point on the surface. <br>
class Poly_Triangle  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Constructs a triangle and sets all indices to zero. <br>
Standard_EXPORT Poly_Triangle();

//! Constructs a triangle and sets its three indices <br>
//! to N1, N2 and N3 respectively, where these node values <br>
//!   are indices in the table of nodes specific to an existing <br>
//!   triangulation of a shape. <br>
Standard_EXPORT Poly_Triangle(const Standard_Integer N1,const Standard_Integer N2,const Standard_Integer N3);

//! Sets the value of  the three nodes of this triangle to N1, N2 and N3   respectively. <br>
Standard_EXPORT   void Set(const Standard_Integer N1,const Standard_Integer N2,const Standard_Integer N3) ;
//! Sets the value of  the Indexth node of this triangle to Node. <br>
//! Raises OutOfRange if Index is not in 1,2,3 <br>
  void Set(const Standard_Integer Index,const Standard_Integer Node) ;

//! Returns the node indices of this triangle in N1, N2 and N3. <br>
Standard_EXPORT   void Get(Standard_Integer& N1,Standard_Integer& N2,Standard_Integer& N3) const;
//! Get the node of given Index. <br>
//! Raises OutOfRange from Standard if Index is not in 1,2,3 <br>
  Standard_Integer Value(const Standard_Integer Index) const;
  Standard_Integer operator()(const Standard_Integer Index) const
{
  return Value(Index);
}

//! Get the node of given Index. <br>
//! Raises OutOfRange if Index is not in 1,2,3 <br>
  Standard_Integer& ChangeValue(const Standard_Integer Index) ;
  Standard_Integer& operator()(const Standard_Integer Index) 
{
  return ChangeValue(Index);
}






protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Standard_Integer myNodes[3];


};


#include <Poly_Triangle.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
