// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _IntTools_ShrunkRange_HeaderFile
#define _IntTools_ShrunkRange_HeaderFile

#ifndef _TopoDS_Edge_HeaderFile
#include <TopoDS_Edge.hxx>
#endif
#ifndef _TopoDS_Vertex_HeaderFile
#include <TopoDS_Vertex.hxx>
#endif
#ifndef _IntTools_Range_HeaderFile
#include <IntTools_Range.hxx>
#endif
#ifndef _Bnd_Box_HeaderFile
#include <Bnd_Box.hxx>
#endif
#ifndef _IntTools_PContext_HeaderFile
#include <IntTools_PContext.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
class TopoDS_Edge;
class TopoDS_Vertex;
class IntTools_Range;
class IntTools_Context;
class Bnd_Box;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif


//!  The class provides the computation of <br>
//!  a working (shrunk) range [t1, t2] for <br>
//!  the 3D-curve of the edge. <br>
class IntTools_ShrunkRange  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


//! Empty constructor <br>
Standard_EXPORT IntTools_ShrunkRange();


Standard_EXPORT IntTools_ShrunkRange(const TopoDS_Edge& aE,const TopoDS_Vertex& aV1,const TopoDS_Vertex& aV2,const IntTools_Range& aR,const IntTools_Context& ICtx);


//! Sets an shrunk range <br>
Standard_EXPORT   void SetShrunkRange(const IntTools_Range& aR) ;


//! Returns shrunk range <br>
Standard_EXPORT  const IntTools_Range& ShrunkRange() const;


//! Returns bounding box for edge restricted <br>
//! by shrunk range <br>
Standard_EXPORT  const Bnd_Box& BndBox() const;


//! Returns edge for which <br>
//! the shrunk range is computed <br>
Standard_EXPORT  const TopoDS_Edge& Edge() const;


//! Computes shrunk range for <br>
//! an edge given in constructor <br>
//! <br>
Standard_EXPORT   void Perform() ;


//! Returns true if no error occured <br>
//! during shrunk range computation <br>
Standard_EXPORT   Standard_Boolean IsDone() const;


//! Returns code of computing shrunk range <br>
//! completion <br>
//! 0 - means successful completion <br>
//! 1 - nothing has been done <br>
//! 2 - initial range is out of edge's range <br>
//! 3 - first boundary of initial range is more than <br>
//!     last boundary <br>
//! 4 - projection of first vertex failed <br>
//! 5 - projection of second vertex failed <br>
//! 6 - shrunk range can not be computed <br>
//!     shrunk range is setted to initial range <br>
Standard_EXPORT   Standard_Integer ErrorStatus() const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
TopoDS_Edge myEdge;
TopoDS_Vertex myV1;
TopoDS_Vertex myV2;
IntTools_Range myRange;
IntTools_Range myShrunkRange;
Bnd_Box myBndBox;
IntTools_PContext myCtx;
Standard_Boolean myIsDone;
Standard_Integer myErrorStatus;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
