// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Geom2dAPI_PointsToBSpline_HeaderFile
#define _Geom2dAPI_PointsToBSpline_HeaderFile

#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Handle_Geom2d_BSplineCurve_HeaderFile
#include <Handle_Geom2d_BSplineCurve.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _GeomAbs_Shape_HeaderFile
#include <GeomAbs_Shape.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
class Geom2d_BSplineCurve;
class StdFail_NotDone;
class TColgp_Array1OfPnt2d;
class TColStd_Array1OfReal;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! This  class  is  used  to  approximate a  BsplineCurve <br>
//!          passing  through an  array  of points,  with  a  given <br>
//!          Continuity. <br>
//!       Describes functions for building a 2D BSpline <br>
//!       curve which approximates a set of points. <br>
//!       A PointsToBSpline object provides a framework for: <br>
//!       -   defining the data of the BSpline curve to be built, <br>
//!       -   implementing the approximation algorithm, and <br>
//!       -   consulting the results <br>
class Geom2dAPI_PointsToBSpline  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Constructs an empty approximation algorithm. <br>
//! Use an Init function to define and build the BSpline curve. <br>
Standard_EXPORT Geom2dAPI_PointsToBSpline();

//! Approximate  a BSpline  Curve passing  through  an <br>
//!          array of  Point.  The resulting BSpline will  have <br>
//!          the following properties: <br>
//!          1- his degree will be in the range [Degmin,Degmax] <br>
//!          2- his  continuity will be  at  least <Continuity> <br>
//!          3- the distance from the point <Points> to the <br>
//!             BSpline will be lower to Tol2D <br>
Standard_EXPORT Geom2dAPI_PointsToBSpline(const TColgp_Array1OfPnt2d& Points,const Standard_Integer DegMin = 3,const Standard_Integer DegMax = 8,const GeomAbs_Shape Continuity = GeomAbs_C2,const Standard_Real Tol2D = 1.0e-6);

//! Approximate  a BSpline  Curve passing  through  an <br>
//!          array of  Point.  Of coordinates : <br>
//! <br>
//!          X = X0 + DX * (i-YValues.Lower()) <br>
//!          Y = YValues(i) <br>
//! <br>
//!          With i in the range YValues.Lower(), YValues.Upper() <br>
//! <br>
//!          The BSpline will be parametrized  from t = X0 to <br>
//!          X0 + DX * (YValues.Upper() - YValues.Lower()) <br>
//! <br>
//!          And will satisfy X(t) = t <br>
//! <br>
//!          The resulting BSpline will  have <br>
//!          the following properties: <br>
//!          1- his degree will be in the range [Degmin,Degmax] <br>
//!          2- his  continuity will be  at  least <Continuity> <br>
//!          3- the distance from the point <Points> to the <br>
//!             BSpline will be lower to Tol2D <br>
Standard_EXPORT Geom2dAPI_PointsToBSpline(const TColStd_Array1OfReal& YValues,const Standard_Real X0,const Standard_Real DX,const Standard_Integer DegMin = 3,const Standard_Integer DegMax = 8,const GeomAbs_Shape Continuity = GeomAbs_C2,const Standard_Real Tol2D = 1.0e-6);

//! Approximate  a BSpline  Curve passing  through  an <br>
//!          array of  Point.  The resulting BSpline will  have <br>
//!          the following properties: <br>
//!          1- his degree will be in the range [Degmin,Degmax] <br>
//!          2- his  continuity will be  at  least <Continuity> <br>
//!          3- the distance from the point <Points> to the <br>
//!             BSpline will be lower to Tol2D <br>
Standard_EXPORT   void Init(const TColgp_Array1OfPnt2d& Points,const Standard_Integer DegMin = 3,const Standard_Integer DegMax = 8,const GeomAbs_Shape Continuity = GeomAbs_C2,const Standard_Real Tol2D = 1.0e-6) ;

//! Approximate  a BSpline  Curve passing  through  an <br>
//!          array of  Point.  Of coordinates : <br>
//! <br>
//!          X = X0 + DX * (i-YValues.Lower()) <br>
//!          Y = YValues(i) <br>
//! <br>
//!          With i in the range YValues.Lower(), YValues.Upper() <br>
//! <br>
//!          The BSpline will be parametrized  from t = X0 to <br>
//!          X0 + DX * (YValues.Upper() - YValues.Lower()) <br>
//! <br>
//!          And will satisfy X(t) = t <br>
//! <br>
//!          The resulting BSpline will  have <br>
//!          the following properties: <br>
//!          1- his degree will be in the range [Degmin,Degmax] <br>
//!          2- his  continuity will be  at  least <Continuity> <br>
//!          3- the distance from the point <Points> to the <br>
//!             BSpline will be lower to Tol2D <br>
Standard_EXPORT   void Init(const TColStd_Array1OfReal& YValues,const Standard_Real X0,const Standard_Real DX,const Standard_Integer DegMin = 3,const Standard_Integer DegMax = 8,const GeomAbs_Shape Continuity = GeomAbs_C2,const Standard_Real Tol2D = 1.0e-6) ;

//! Returns the approximate BSpline Curve <br>
Standard_EXPORT  const Handle_Geom2d_BSplineCurve& Curve() const;
Standard_EXPORT operator Handle(Geom2d_BSplineCurve)() const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Standard_Boolean myIsDone;
Handle_Geom2d_BSplineCurve myCurve;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
