// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _GProp_PGProps_HeaderFile
#define _GProp_PGProps_HeaderFile

#ifndef _GProp_GProps_HeaderFile
#include <GProp_GProps.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
class Standard_DimensionError;
class Standard_DomainError;
class gp_Pnt;
class TColgp_Array1OfPnt;
class TColgp_Array2OfPnt;
class TColStd_Array1OfReal;
class TColStd_Array2OfReal;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! A framework for computing the global properties of a <br>
//! set of points. <br>
//! A point mass is attached to each point. The global <br>
//! mass of the system is the sum of each individual <br>
//! mass. By default, the point mass is equal to 1 and the <br>
//! mass of a system composed of N points is equal to N. <br>
//! Warning <br>
//! A framework of this sort provides functions to handle <br>
//! sets of points easily. But, like any GProp_GProps <br>
//! object, by using the Add function, it can theoretically <br>
//! bring together the computed global properties and <br>
//! those of a system more complex than a set of points . <br>
//! The mass of each point and the density of each <br>
//! component of the composed system must be <br>
//! coherent. Note that this coherence cannot be checked. <br>
//! Nonetheless, you are advised to restrict your use of a <br>
//! GProp_PGProps object to a set of points and to <br>
//! create a GProp_GProps object in order to bring <br>
//! together global properties of different systems. <br>
class GProp_PGProps  : public GProp_GProps {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Initializes a framework to compute global properties <br>
//! on a set of points. <br>
//! The point relative to which the inertia of the system is <br>
//! computed will be the origin (0, 0, 0) of the <br>
//! absolute Cartesian coordinate system. <br>
//! At initialization, the framework is empty, i.e. it retains <br>
//! no dimensional information such as mass and inertia. <br>
//! It is, however, now able to keep global properties of a <br>
//! set of points while new points are added using the <br>
//! AddPoint function. <br>
//! The set of points whose global properties are brought <br>
//! together by this framework will then be referred to as <br>
//! the current system. The current system is, however, <br>
//! not kept by this framework, which only keeps that <br>
//! system's global properties. Note that the current <br>
//! system may be more complex than a set of points. <br>
Standard_EXPORT GProp_PGProps();

//! Brings together the global properties already <br>
//! retained by this framework with those induced by <br>
//! the point Pnt. Pnt may be the first point of the current system. <br>
//! A point mass is attached to the point Pnt, it is either <br>
//! equal to 1. or to Density. <br>
Standard_EXPORT   void AddPoint(const gp_Pnt& P) ;


//!  Adds a new point P with its density in the system of points <br>
//! Exceptions <br>
//! Standard_DomainError if the mass value Density <br>
//! is less than gp::Resolution(). <br>
Standard_EXPORT   void AddPoint(const gp_Pnt& P,const Standard_Real Density) ;


//!  computes the global properties of the system of points Pnts. <br>
//!  The density of the points are defaulted to all being 1 <br>
Standard_EXPORT GProp_PGProps(const TColgp_Array1OfPnt& Pnts);


//!  computes the global properties of the system of points Pnts. <br>
//!  The density of the points are defaulted to all being 1 <br>
Standard_EXPORT GProp_PGProps(const TColgp_Array2OfPnt& Pnts);


//!  computes the global properties of the system of points Pnts. <br>
//!  A density is associated with each point. <br>
//!  raises if a density is lower or equal to Resolution from package <br>
//!  gp. <br>
//!  raises if the length of Pnts and the length of Density <br>
//!  is not the same. <br>
Standard_EXPORT GProp_PGProps(const TColgp_Array1OfPnt& Pnts,const TColStd_Array1OfReal& Density);


//!  computes the global properties of the system of points Pnts. <br>
//!  A density is associated with each point. <br>
//!  Raised if a density is lower or equal to Resolution from package <br>
//!  gp. <br>
//!  Raised if the length of Pnts and the length of Density <br>
//!  is not the same. <br>
Standard_EXPORT GProp_PGProps(const TColgp_Array2OfPnt& Pnts,const TColStd_Array2OfReal& Density);


//!  Computes the barycentre of a set of points. The density of the <br>
//!  points is defaulted to 1. <br>
Standard_EXPORT static  gp_Pnt Barycentre(const TColgp_Array1OfPnt& Pnts) ;


//!  Computes the barycentre of a set of points. The density of the <br>
//!  points is defaulted to 1. <br>
Standard_EXPORT static  gp_Pnt Barycentre(const TColgp_Array2OfPnt& Pnts) ;


//!  Computes the barycentre of a set of points. A density is associated <br>
//!  with each point. <br>
//!  raises if a density is lower or equal to Resolution from package <br>
//!  gp. <br>
//!  Raised if the length of Pnts and the length of Density <br>
//!  is not the same. <br>
Standard_EXPORT static  void Barycentre(const TColgp_Array1OfPnt& Pnts,const TColStd_Array1OfReal& Density,Standard_Real& Mass,gp_Pnt& G) ;


//!  Computes the barycentre of a set of points. A density is associated <br>
//!  with each point. <br>
//!  Raised if a density is lower or equal to Resolution from package <br>
//!  gp. <br>
//!  Raised if the length of Pnts and the length of Density <br>
//!  is not the same. <br>
Standard_EXPORT static  void Barycentre(const TColgp_Array2OfPnt& Pnts,const TColStd_Array2OfReal& Density,Standard_Real& Mass,gp_Pnt& G) ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
