// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _GC_MakeTranslation_HeaderFile
#define _GC_MakeTranslation_HeaderFile

#ifndef _Handle_Geom_Transformation_HeaderFile
#include <Handle_Geom_Transformation.hxx>
#endif
class Geom_Transformation;
class gp_Vec;
class gp_Pnt;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! This class mplements elementary construction algorithms for a <br>
//! translation in 3D space. The result is a <br>
//! Geom_Transformation transformation. <br>
//! A MakeTranslation object provides a framework for: <br>
//! -   defining the construction of the transformation, <br>
//! -   implementing the construction algorithm, and <br>
//! -   consulting the result. <br>
class GC_MakeTranslation  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Constructs a translation along the vector " Vect " <br>
Standard_EXPORT GC_MakeTranslation(const gp_Vec& Vect);

//! Constructs a translation along the vector (Point1,Point2) <br>
//!  defined from the point Point1 to the point Point2. <br>
Standard_EXPORT GC_MakeTranslation(const gp_Pnt& Point1,const gp_Pnt& Point2);

//!  Returns the constructed transformation. <br>
Standard_EXPORT  const Handle_Geom_Transformation& Value() const;


Standard_EXPORT  const Handle_Geom_Transformation& Operator() const;
Standard_EXPORT operator Handle_Geom_Transformation() const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Handle_Geom_Transformation TheTranslation;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
