// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _GC_MakeHyperbola_HeaderFile
#define _GC_MakeHyperbola_HeaderFile

#ifndef _Handle_Geom_Hyperbola_HeaderFile
#include <Handle_Geom_Hyperbola.hxx>
#endif
#ifndef _GC_Root_HeaderFile
#include <GC_Root.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
class Geom_Hyperbola;
class StdFail_NotDone;
class gp_Hypr;
class gp_Ax2;
class gp_Pnt;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//!This class implements construction algorithms for a hyperbola in <br>
//! 3D space. The result is a Geom_Hyperbola hyperbola. <br>
//! A MakeHyperbola object provides a framework for: <br>
//! -   defining the construction of the hyperbola, <br>
//! -   implementing the construction algorithm, and <br>
//! -   consulting the results. In particular, the Value <br>
//!   function returns the constructed hyperbola. <br>
//!  To define the main branch of an hyperbola. <br>
//!  The parameterization range is ]-infinite,+infinite[ <br>
//!  It is possible to get the other branch and the two conjugate <br>
//!  branches of the main branch. <br>
class GC_MakeHyperbola  : public GC_Root {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


//!  Creates  an Hyperbola from a non persistent hyperbola  from package gp by conversion. <br>
Standard_EXPORT GC_MakeHyperbola(const gp_Hypr& H);

//! Constructs a hyperbola centered on the origin of the coordinate system <br>
//! A2, with major and minor radii MajorRadius and MinorRadius, where: <br>
//!   the plane of the hyperbola is defined by the "X Axis" and "Y Axis" of A2, <br>
//!   -   its major axis is the "X Axis" of A2. <br>
Standard_EXPORT GC_MakeHyperbola(const gp_Ax2& A2,const Standard_Real MajorRadius,const Standard_Real MinorRadius);

//! Constructs a hyperbola centered on the point Center, where <br>
//!   -   the plane of the hyperbola is defined by Center, S1 and S2, <br>
//!   -   its major axis is defined by Center and S1, <br>
//!   -   its major radius is the distance between Center and S1, and <br>
//!   -   its minor radius is the distance between S2 and the major axis; <br>
Standard_EXPORT GC_MakeHyperbola(const gp_Pnt& S1,const gp_Pnt& S2,const gp_Pnt& Center);

//! Returns the constructed hyperbola. <br>
//! Exceptions StdFail_NotDone if no hyperbola is constructed. <br>
Standard_EXPORT  const Handle_Geom_Hyperbola& Value() const;


Standard_EXPORT  const Handle_Geom_Hyperbola& Operator() const;
Standard_EXPORT operator Handle_Geom_Hyperbola() const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Handle_Geom_Hyperbola TheHyperbola;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
