// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _FairCurve_EnergyOfMVC_HeaderFile
#define _FairCurve_EnergyOfMVC_HeaderFile

#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _FairCurve_BattenLaw_HeaderFile
#include <FairCurve_BattenLaw.hxx>
#endif
#ifndef _FairCurve_DistributionOfTension_HeaderFile
#include <FairCurve_DistributionOfTension.hxx>
#endif
#ifndef _FairCurve_DistributionOfSagging_HeaderFile
#include <FairCurve_DistributionOfSagging.hxx>
#endif
#ifndef _FairCurve_DistributionOfJerk_HeaderFile
#include <FairCurve_DistributionOfJerk.hxx>
#endif
#ifndef _FairCurve_AnalysisCode_HeaderFile
#include <FairCurve_AnalysisCode.hxx>
#endif
#ifndef _FairCurve_Energy_HeaderFile
#include <FairCurve_Energy.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Handle_TColStd_HArray1OfReal_HeaderFile
#include <Handle_TColStd_HArray1OfReal.hxx>
#endif
#ifndef _Handle_TColgp_HArray1OfPnt2d_HeaderFile
#include <Handle_TColgp_HArray1OfPnt2d.hxx>
#endif
class Standard_DomainError;
class TColStd_HArray1OfReal;
class TColgp_HArray1OfPnt2d;
class FairCurve_BattenLaw;
class math_Vector;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Energy Criterium to minimize in MinimalVariationCurve. <br>
class FairCurve_EnergyOfMVC  : public FairCurve_Energy {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Angles corresspond to the Ox axis <br>
Standard_EXPORT FairCurve_EnergyOfMVC(const Standard_Integer BSplOrder,const Handle(TColStd_HArray1OfReal)& FlatKnots,const Handle(TColgp_HArray1OfPnt2d)& Poles,const Standard_Integer ContrOrder1,const Standard_Integer ContrOrder2,const FairCurve_BattenLaw& Law,const Standard_Real PhysicalRatio,const Standard_Real LengthSliding,const Standard_Boolean FreeSliding = Standard_True,const Standard_Real Angle1 = 0,const Standard_Real Angle2 = 0,const Standard_Real Curvature1 = 0,const Standard_Real Curvature2 = 0);
//! return  the  lengthSliding = P1P2 + Sliding <br>
  Standard_Real LengthSliding() const;
//! return  the status <br>
  FairCurve_AnalysisCode Status() const;

//! compute the variables <X> wich correspond with the field <MyPoles> <br>
Standard_EXPORT virtual  Standard_Boolean Variable(math_Vector& X) const;





protected:

 // Methods PROTECTED
 // 

//! compute  the  poles wich correspond with the variable X <br>
Standard_EXPORT virtual  void ComputePoles(const math_Vector& X) ;

//! compute the energy in intermediat format <br>
Standard_EXPORT virtual  Standard_Boolean Compute(const Standard_Integer DerivativeOrder,math_Vector& Result) ;


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Standard_Real MyLengthSliding;
Standard_Real OriginalSliding;
Standard_Boolean MyFreeSliding;
FairCurve_BattenLaw MyBattenLaw;
Standard_Real MyPhysicalRatio;
FairCurve_DistributionOfTension MyTension;
FairCurve_DistributionOfSagging MySagging;
FairCurve_DistributionOfJerk MyJerk;
FairCurve_AnalysisCode MyStatus;


};


#include <FairCurve_EnergyOfMVC.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
