// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _BRepPrimAPI_MakeWedge_HeaderFile
#define _BRepPrimAPI_MakeWedge_HeaderFile

#ifndef _BRepPrim_Wedge_HeaderFile
#include <BRepPrim_Wedge.hxx>
#endif
#ifndef _BRepBuilderAPI_MakeShape_HeaderFile
#include <BRepBuilderAPI_MakeShape.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
class Standard_DomainError;
class StdFail_NotDone;
class gp_Ax2;
class BRepPrim_Wedge;
class TopoDS_Shell;
class TopoDS_Solid;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Describes functions to build wedges, i.e. boxes with inclined faces. <br>
//! A MakeWedge object provides a framework for: <br>
//! -   defining the construction of a wedge, <br>
//! -   implementing the construction algorithm, and <br>
//! -   consulting the result. <br>
class BRepPrimAPI_MakeWedge  : public BRepBuilderAPI_MakeShape {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Make a STEP right angular wedge. (ltx >= 0) <br>
Standard_EXPORT BRepPrimAPI_MakeWedge(const Standard_Real dx,const Standard_Real dy,const Standard_Real dz,const Standard_Real ltx);

//! Make a STEP right angular wedge. (ltx >= 0) <br>
Standard_EXPORT BRepPrimAPI_MakeWedge(const gp_Ax2& Axes,const Standard_Real dx,const Standard_Real dy,const Standard_Real dz,const Standard_Real ltx);

//! Make a wedge. The face at dy is xmin,zmin xmax,zmax <br>
Standard_EXPORT BRepPrimAPI_MakeWedge(const Standard_Real dx,const Standard_Real dy,const Standard_Real dz,const Standard_Real xmin,const Standard_Real zmin,const Standard_Real xmax,const Standard_Real zmax);

//! Make a wedge. The face at dy is xmin,zmin xmax,zmax <br>
Standard_EXPORT BRepPrimAPI_MakeWedge(const gp_Ax2& Axes,const Standard_Real dx,const Standard_Real dy,const Standard_Real dz,const Standard_Real xmin,const Standard_Real zmin,const Standard_Real xmax,const Standard_Real zmax);

//! Returns the internal algorithm. <br>
//! <br>
Standard_EXPORT   BRepPrim_Wedge& Wedge() ;

//! Stores the solid in myShape. <br>
Standard_EXPORT virtual  void Build() ;

//! Returns the constructed box in the form of a shell. <br>
Standard_EXPORT  const TopoDS_Shell& Shell() ;
Standard_EXPORT operator TopoDS_Shell();

//! Returns the constructed box in the form of a solid. <br>
Standard_EXPORT  const TopoDS_Solid& Solid() ;
Standard_EXPORT operator TopoDS_Solid();





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
BRepPrim_Wedge myWedge;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
