/*
 *  Nikwi Deluxe
 *  Copyright (C) 2006  Kostas Michalopoulos
 *  
 *  A game by Kostas "Bad Sector" Michalopoulos
 *  email: badsector@slashstone.com
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
** Nikwi Engine - Sprites
*/

#ifndef __SPRITES_H_INCLUDED__
#define __SPRITES_H_INCLUDED__

struct Frame
{
	SDL_Surface	*image;
	SDL_Surface	*mirror;	
	unsigned short	*localCopy;
	
	Frame();
	~Frame();
	
	void makeMirror();
	
	void draw(int x, int y, bool drawMirror);
};

struct Sprite
{
	String		name;
	Frame		**frame;
	Frame		*cframe;
	uint		frames;
	uint		delay;
	int		bx1, by1, bx2, by2;
	int		offsetX, offsetY;
	
	Sprite		*next;
	
	Sprite(String name);
	~Sprite();
	
	void addFrame(Frame *frame);
	void calcBoundingBox();
	
	bool collideWith(int x1, int y1, Sprite *spr, int x2, int y2);
};

struct SpriteState
{
	Sprite		*sprite;
	Frame		*frame;
	uint		index;
	uint		counter;
	bool		mirror;
	bool		paused;
	
	SpriteState(Sprite *sprite);
	~SpriteState();

	void draw(int x, int y);
	void animate();
};

extern Sprite	*cursor;

void initSprites();
void shutdownSprites();

Sprite *findSprite(String name);

#endif

