/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.CodeAttr;
import gnu.bytecode.Field;
import gnu.bytecode.Method;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.Expression;
import gnu.expr.Initializer;
import gnu.expr.Literal;
import gnu.expr.QuoteExp;

public class BindingInitializer
extends Initializer {
    Declaration decl;
    Expression value;
    static final Method makeBindingMethod = Compilation.typeBinding.getDeclaredMethod("make", Compilation.string1Arg);
    boolean createNewBinding = false;

    public BindingInitializer(Declaration decl, Field field, Expression value) {
        this.decl = decl;
        this.value = value;
        this.field = field;
    }

    @Override
    public void emit(Compilation comp) {
        CodeAttr code = comp.getCode();
        if (this.value instanceof QuoteExp) {
            Object val = ((QuoteExp)this.value).getValue();
            if (val == null || val instanceof String) {
                return;
            }
            Literal lit = comp.findLiteral(val);
            if (lit.field == this.field) {
                return;
            }
        }
        if (!this.field.getStaticFlag()) {
            code.emitPushThis();
        }
        if (this.value == null) {
            String name;
            if (!this.createNewBinding) {
                code.emitInvokeStatic(Compilation.getCurrentEnvironmentMethod);
            }
            if ((name = this.decl.getName()) == null) {
                code.emitPushNull();
            } else {
                code.emitPushString(name);
            }
            if (this.createNewBinding) {
                code.emitInvokeStatic(makeBindingMethod);
            } else {
                code.emitInvokeVirtual(Compilation.getBindingEnvironmentMethod);
            }
        } else {
            this.value.compile(comp, this.field.getType());
        }
        if (this.field.getStaticFlag()) {
            code.emitPutStatic(this.field);
        } else {
            code.emitPutField(this.field);
        }
    }
}

