/*
 * Decompiled with CFR 0.152.
 */
package bossa.syntax;

import bossa.modules.Compilation;
import bossa.modules.Package;
import bossa.syntax.LocatedString;
import bossa.syntax.Node;
import bossa.syntax.Symbol;
import bossa.syntax.VarScope;
import bossa.syntax.dispatch;
import bossa.util.Located;
import bossa.util.User;
import gnu.bytecode.ClassType;
import gnu.bytecode.Type;
import java.util.List;
import mlsub.typing.TypeConstructor;
import nice.tools.code.Types;
import nice.tools.visibility.Scope;

public class Module {
    public final Package pkg;
    VarScope scope;
    String name;

    public Module(Package pkg, String name, Scope scope) {
        this.pkg = pkg;
        this.name = name;
        this.scope = dispatch.createGlobalVarScope(0, scope);
    }

    Compilation compilation() {
        return this.pkg.getCompilation();
    }

    public boolean compiled() {
        return this.pkg.interfaceFile();
    }

    public void addStaticImport(LocatedString value) {
        List symbols;
        Type type;
        String fullName = value.toString();
        int lastDot = fullName.lastIndexOf(46);
        if (lastDot == -1) {
            User.error((Located)value, "Missing field or method name");
        }
        String methodName = fullName.substring(lastDot + 1);
        fullName = fullName.substring(0, lastDot);
        TypeConstructor tc = Node.getGlobalTypeScope().globalLookup(fullName, value.location());
        if (tc == null) {
            User.error((Located)value, "Unknown class: " + fullName);
        }
        if (!((type = Types.javaType(tc)) instanceof ClassType)) {
            User.error((Located)value, fullName + " is not a class");
        }
        if ((symbols = dispatch.findJavaMethods((ClassType)type, methodName)).size() == 0) {
            User.error((Located)value, methodName + " is not a static field or method of class " + fullName);
        }
        for (Symbol s : symbols) {
            this.scope.addSymbol(s);
        }
    }
}

