/** \file extract_warnings.cpp
 * Defines the entry point for the DLL application
 *
 * $Id: extract_warnings.cpp,v 1.3 2005-06-23 18:18:10 boucher Exp $
 */

/* Copyright, 2003 Nevrax Ltd.
 *
 * This file is part of NEVRAX NEL.
 * NEVRAX NEL is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.

 * NEVRAX NEL is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with NEVRAX NEL; see the file COPYING. If not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA.
 */

//
// Log Analyser plug-in that summarize the warnings found in log files.
//
// To register this plug-in in the Log Analyser, drag-n-drop the DLL
// onto the main window of the Log Analyser.
//
// Note: This DLL can't be use with any configuration of log_analyser.exe.
// If the Log Analyser is compiler with __STL_DEBUG enabled, __STL_DEBUG must
// be enabled in the DLL, and vice versa.
//

#include "stdafx.h"

#define LOG_ANALYSER_PLUGIN_EXPORTS
#include "extract_warnings.h"
#include <stdio.h>
#include <string>
using namespace std;

#include <nel/misc/mem_displayer.h>
#include "nel/misc/app_context.h"

// Using directly the log report class from nelns
#include "../../nelns/admin_executor_service/log_report.h"

#include <windows.h>


BOOL APIENTRY DllMain( HANDLE hModule, 
                       DWORD  ul_reason_for_call, 
                       LPVOID lpReserved
					 )
{
	// initialize nel context
	if (!NLMISC::INelContext::isContextInitialised())
		new NLMISC::CApplicationContext();
			
    switch (ul_reason_for_call)
	{
		case DLL_PROCESS_ATTACH:
		case DLL_THREAD_ATTACH:
		case DLL_THREAD_DETACH:
		case DLL_PROCESS_DETACH:
			break;
    }
    return TRUE;
}


/*
 *
 */
LOG_ANALYSER_PLUGIN_API std::string getInfoString()
{
	return "Input log: Any log file(s) generated by a NeL program.\n\nSummarizes all warnings (lines containing WRN) by number of occurences.";
}


/*
 *
 */
LOG_ANALYSER_PLUGIN_API bool doAnalyse( const std::vector<const char *>& vec, std::string& res, std::string& log )
{
	// ---
	// Optional: Demo of how to get NeL logs (1/2)
	// Outside this function, include <nel/misc/debug.h> and use namespace NLMISC.
	//NLMISC::createDebug();
	//CMemDisplayer memdisp;
	//NLMISC::DebugLog->addDisplayer( &memdisp );
	//NLMISC::InfoLog->addDisplayer( &memdisp );
	//NLMISC::WarningLog->addDisplayer( &memdisp );
	// ErrorLog and AssertLog not needed, they stop the application.
	// ---

	// Analyse warnings from vec
	MainLogReport.reset();
	int nb = 0;
	string line;
	vector<const char *>::const_iterator iv;
	for ( iv=vec.begin(); iv!=vec.end(); ++iv )
	{
		line = string(*iv);
		MainLogReport.pushLine( line );
	}
	log = "Log report done.\nUse Right-Click > Select All then Copy (Ctrl+C) to copy the report from the top window.\n \n";

	// Fill report to res
	NLMISC::CLightMemDisplayer disp;
	NLMISC::CLog reportLog;
	reportLog.addDisplayer( &disp );
	MainLogReport.report( &reportLog, true );
	disp.write( res, true );
	disp.write( log, false );

	// ---
	// Optional: Demo of how to get all NeL logs (2/2)
	//memdisp.write( log );
	// ---

	return true;
}


