--------------------------------------------------------------------------
--                                                                      --
--           Copyright: Copyright (C) 2000-2010 CNRS/IN2P3              --
--                                                                      --
-- Narval framework is free  software; you can redistribute  it and/or  --
-- modify  it   under  terms  of  the  GNU General  Public  License as  --
-- published  by  the  Free Software Foundation; either version  2, or  --
-- (at your option) any later version. Narval framework is distributed  --
-- in the hope  that  they will  be useful, but  WITHOUT ANY WARRANTY;  --
-- without even the implied warranty of  MERCHANTABILITY or FITNESS FOR --
-- A PARTICULAR PURPOSE. See the  GNU. General Public License for more  --
-- details. You should have received  a copy of the GNU General Public  --
-- License distributed with Narval; see file COPYING. If not, write to  --
-- the Free Software  Foundation,  Inc., 51 Franklin St,  Fifth Floor,  --
-- Boston, MA 02110-1301 USA.                                           --
--------------------------------------------------------------------------
with Ada.Calendar;

package Narval.Actors.Actives.Consumers.Data_Rate is

   type Data_Rate_Consumer_Type is new Consumer_Type with private;

private

   task type Data_Rate_Calculation_Task_Type
     (Wrapper : access Data_Rate_Consumer_Type) is
      entry Start;
      entry Stop;
   end Data_Rate_Calculation_Task_Type;

   type Data_Rate_Consumer_Type is new Consumer_Type with record
      Start_Date : Ada.Calendar.Time;
      Stop_Date : Ada.Calendar.Time;
      Number_Of_Bytes_Received : Long_Float;
      Pause_On : Boolean;
      Data_Rate_Calculation_Task : Data_Rate_Calculation_Task_Type
        (Data_Rate_Consumer_Type'Access);
      Data_Rate_Parameter : Parameters.Parameter_Access;
   end record;

   procedure Buffer_Handling
     (Object : access Data_Rate_Consumer_Type);
   procedure On_Initialise
     (Object : access Data_Rate_Consumer_Type);
   procedure On_Start (Object : access Data_Rate_Consumer_Type);
   procedure On_Stop (Object : access Data_Rate_Consumer_Type);
   procedure On_Suspend (Object : access Data_Rate_Consumer_Type);

end Narval.Actors.Actives.Consumers.Data_Rate;
