# -*- coding: utf-8 -*-
# Moovida - Home multimedia server
# Copyright (C) 2006-2009 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Moovida with Fluendo's plugins.
#
# The GPL part of Moovida is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Moovida" in the root directory of this distribution package
# for details on that license.

from elisa.plugins.pigment.widgets.range import Range


class ProgressBar(Range):

    def __init__(self):
        self.sensitive = False
        self.seek_drag = False

        super(ProgressBar, self).__init__()

    def set_fraction(self, fraction):

        assert(0<= fraction <= 1)
        if fraction == 0:
            self.current_index = 0
        else:
            self.current_index = int(self.items_number * fraction) - 1

    def do_index_changed(self, current, previous):
        if 0 <= current <= self.items_number:
            self._update_cursor_size()


    def _pressed(self, widget, x, y, z, button, time, pressure):
        if not self.sensitive:
            return True

        idx = self._get_index_from_position(x, y, z)
        if idx > self.items_number:
            # stupid but possible: move the drag over the size of the widgets
            return True

        self.current_index = idx
        return True


    def _drag_begin(self, widget, x, y, z, button, time, pressure):
        if not self.sensitive:
            return True

        self.seek_drag = True
        return True

    def _drag_motion(self, widget, x, y, z, button, time, pressure):
        if not self.sensitive:
            return True

        idx = self._get_index_from_position(x, y, z)
        if idx > self.items_number:
            # stupid but possible: move the drag over the size of the widgets
            return True

        self.current_index = idx
        return True

    def _drag_end(self, widget, x, y, z, button, time):
        if not self.sensitive:
            return True
        self.seek_drag = False
        return True

    @classmethod
    def _demo_widget(cls, *args, **kwargs):
        widget = cls()
        widget.size = (100.0, 100.0)
        widget.items_number = 12
        widget.visible = True

        return widget


if __name__ == "__main__":
    import logging
    logger = logging.getLogger()
    logger.setLevel(logging.DEBUG)

    progressbar = ProgressBar.demo ()
    try:
        __IPYTHON__
    except NameError:
        import pgm
        pgm.main()
