/* Copyright (C) 2004 Mads Martin Joergensen <mmj at mmj dot dk>
 *
 * $Id: dumpfd2fd.c,v 1.4 2004/06/16 21:11:53 mmj Exp $
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to
 * deal in the Software without restriction, including without limitation the
 * rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
 * sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 */

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <errno.h>

#include "wrappers.h"

#define DUMPBUF 4096

int dumpfd2fd(int infd, int outfd)
{
	size_t n;
	char buf[DUMPBUF];

	while((n = read(infd, &buf, sizeof(buf))) != 0) {
		if(n < 0) {
			if(errno == EINTR)
				continue;
			else
				return -1; /* Caller can check errno */
		}
		if(writen(outfd, &buf, n) < 0)
			return -1; /* Caller can check errno */
	}
	
	return 0;
}
