require("mooedittest")
require("munit")

t = mooedittest.new_text_view()
tassert(t:get_text() == '', "t:get_text() == ''")
t:insert_text("a")
t:insert_text("b")
tassert(t:get_text() == 'ab', "t:get_text() == 'ab'")

tassert_eq(t:get_cursor(), 3)
tassert_eq(t:get_selection_bound(), 3)
tassert_eq(t:get_selected_text(), nil)
t:select_range(1)
tassert_eq(t:get_cursor(), 3)
tassert_eq(t:get_selection_bound(), 1)
tassert_eq({t:get_selection()}, {1, 3})
tassert_eq(t:get_selected_text(), 'ab')
t:select_range(1,2)
tassert_eq(t:get_cursor(), 2)
tassert_eq(t:get_selection_bound(), 1)
tassert_eq({t:get_selection()}, {1, 2})
tassert_eq(t:get_selected_text(), 'a')
t:select_range(2,1)
tassert_eq(t:get_cursor(), 1)
tassert_eq(t:get_selection_bound(), 2)
tassert_eq({t:get_selection()}, {1, 2})
tassert_eq(t:get_selected_text(), 'a')

t:select_range(1)
tassert_eq(t:get_selected_text(), 'ab')
t:set_cursor(2)
tassert_eq(t:get_cursor(), 2)
tassert_eq(t:get_selection_bound(), 2)
tassert_eq(t:get_selected_text(), nil)

t:select_range(1)
tassert_eq(t:get_selected_text(), 'ab')
t:unselect()
tassert_eq(t:get_cursor(), 3)
tassert_eq(t:get_selection_bound(), 3)
tassert_eq(t:get_selected_text(), nil)

t:scroll_to_cursor()

t:set_text('abcdef')
tassert_eq(t:get_text(), 'abcdef')
t:select_range(3, 5)
tassert_eq(t:get_selected_text(), 'cd')
t:delete_selection()
tassert_eq(t:get_selected_text(), nil)
tassert_eq(t:get_text(), 'abef')
tassert_eq(t:get_cursor(), 3)

t:delete_range(3)
tassert_eq(t:get_selected_text(), nil)
tassert_eq(t:get_text(), 'ab')
tassert_eq(t:get_cursor(), 3)
t:set_text('abcdef')
t:set_cursor(3)
t:delete_range(2,6)
tassert_eq(t:get_selected_text(), nil)
tassert_eq(t:get_text(), 'af')
tassert_eq(t:get_cursor(), 2)

t:set_text('abcdef')
t:select_range(2,6)
t:replace_selection('BCDE')
tassert_eq(t:get_text(), 'aBCDEf')
t:set_cursor(1)
t:insert_text('A')
tassert_eq(t:get_text(), 'AaBCDEf')
t:insert_text('A', 8)
tassert_eq(t:get_text(), 'AaBCDEfA')

t:set_text('abcdef')
tassert_eq(t:get_text(1,2), 'a')
tassert_eq(t:get_text(1), 'abcdef')
t:delete_range(1)
tassert_eq(t:get_text(1), '')
tassert_eq(t:get_text(), '')

t:set_text('')
tassert_eq(t:get_char_count(), 0)
tassert_eq(t:get_line_count(), 1)
tassert_eq({t:get_pos_at_line(1)}, {1, 1, 1})
tassert_eq(t:get_line_at_pos(1), 1)
tassert_eq(t:get_line_at_cursor(), 1)
tassert_eq(t:get_line_text(), '')
tassert_eq(t:get_line_text(1), '')

t:set_text('abcdef')
t:set_cursor(3)
tassert_eq(t:get_char_count(), 6)
tassert_eq(t:get_line_count(), 1)
tassert_eq({t:get_pos_at_line(1)}, {1, 7, 7})
tassert_eq(t:get_line_at_pos(1), 1)
tassert_eq(t:get_line_at_cursor(), 1)
tassert_eq(t:get_line_text(), 'abcdef')
tassert_eq(t:get_line_text(1), 'abcdef')

t:set_text('abcdef\nghijk')
tassert_eq(t:get_char_count(), 12)
tassert_eq(t:get_line_count(), 2)
tassert_eq({t:get_pos_at_line(1)}, {1, 7, 8})
tassert_eq(t:get_line_at_pos(1), 1)
tassert_eq({t:get_pos_at_line(2)}, {8, 13, 13})
tassert_eq(t:get_line_at_pos(8), 2)
tassert_eq(t:get_line_at_pos(11), 2)
tassert_eq(t:get_line_at_pos(12), 2)
tassert_eq(t:get_line_text(1), 'abcdef')
tassert_eq(t:get_line_text(2), 'ghijk')
t:set_cursor(3)
tassert_eq(t:get_line_at_cursor(), 1)
tassert_eq(t:get_line_text(), 'abcdef')
t:set_cursor(9)
tassert_eq(t:get_line_at_cursor(), 2)
tassert_eq(t:get_line_text(), 'ghijk')

t:set_text('abcdef\n')
tassert_eq(t:get_char_count(), 7)
tassert_eq(t:get_line_count(), 2)
tassert_eq({t:get_pos_at_line(1)}, {1, 7, 8})
tassert_eq(t:get_line_at_pos(1), 1)
tassert_eq({t:get_pos_at_line(2)}, {8, 8, 8})
tassert_eq(t:get_line_at_pos(8), 2)
tassert_eq(t:get_line_text(1), 'abcdef')
tassert_eq(t:get_line_text(2), '')
t:set_cursor(3)
tassert_eq(t:get_line_at_cursor(), 1)
tassert_eq(t:get_line_text(), 'abcdef')
t:set_cursor(8)
tassert_eq(t:get_line_at_cursor(), 2)
tassert_eq(t:get_line_text(), '')

t:set_text('a\r\nb\n')
tassert_eq(t:get_char_count(), 5)
tassert_eq(t:get_line_count(), 3)
tassert_eq(t:get_line_at_pos(1), 1)
tassert_eq(t:get_line_at_pos(2), 1)
tassert_eq(t:get_line_at_pos(3), 1)
tassert_eq(t:get_line_at_pos(4), 2)
tassert_eq(t:get_line_at_pos(5), 2)
tassert_eq(t:get_line_at_pos(6), 3)
tassert_eq({t:get_pos_at_line(1)}, {1, 2, 4})
tassert_eq({t:get_pos_at_line(2)}, {4, 5, 6})
tassert_eq({t:get_pos_at_line(3)}, {6, 6, 6})
tassert_eq(t:get_line_text(1), 'a')
tassert_eq(t:get_line_text(2), 'b')
tassert_eq(t:get_line_text(3), '')

t:set_text('a\r\nb\n')
tassert_eq(t:next_pos(1), 2)
tassert_eq(t:next_pos(2), 4)
tassert_eq(t:next_pos(4), 5)
tassert_eq(t:next_pos(5), 6)
tassert_eq(t:prev_pos(2), 1)
tassert_eq(t:prev_pos(4), 2)
tassert_eq(t:prev_pos(5), 4)
tassert_eq(t:prev_pos(6), 5)
tassert_eq(t:is_cursor_pos(1), true)
tassert_eq(t:is_cursor_pos(2), true)
tassert_eq(t:is_cursor_pos(3), false)
tassert_eq(t:is_cursor_pos(4), true)
tassert_eq(t:is_cursor_pos(5), true)
tassert_eq(t:is_cursor_pos(6), false)
tassert_eq(t:is_end_pos(4), false)
tassert_eq(t:is_end_pos(6), true)
tassert_eq(t:get_end_pos(), 6)

t:set_text('ÀAA\204\128')
tassert_eq(t:next_pos(1), 2)
tassert_eq(t:next_pos(2), 3)
tassert_eq(t:next_pos(3), 5)
tassert_eq(t:prev_pos(5), 3)
tassert_eq(t:prev_pos(3), 2)
tassert_eq(t:prev_pos(2), 1)
tassert_eq(t:is_cursor_pos(1), true)
tassert_eq(t:is_cursor_pos(2), true)
tassert_eq(t:is_cursor_pos(3), true)
tassert_eq(t:is_cursor_pos(4), false)
tassert_eq(t:is_end_pos(4), false)
tassert_eq(t:is_end_pos(5), true)
tassert_eq(t:get_end_pos(), 5)

-- mooedittest.present(t)
