/*************************************************************************
* COPYRIGHT (C) 1999 - 2007  EDF R&D, CEA/DEN
* THIS LIBRARY IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
* IT UNDER THE TERMS OF THE GNU LESSER GENERAL PUBLIC LICENSE 
* AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
* EITHER VERSION 2.1 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
*  
* THIS LIBRARY IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
* WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
* MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
* LESSER GENERAL PUBLIC LICENSE FOR MORE DETAILS.
*
* YOU SHOULD HAVE RECEIVED A COPY OF THE GNU LESSER GENERAL PUBLIC LICENSE
* ALONG WITH THIS LIBRARY; IF NOT, WRITE TO THE FREE SOFTWARE FOUNDATION,
* INC., 59 TEMPLE PLACE, SUITE 330, BOSTON, MA 02111-1307 USA
*
*************************************************************************/

#ifndef MESGERR
#define MESGERR 1
#endif

#ifdef __cplusplus
extern "C" {
#endif

#include "med_config.h"
#include "med_outils.h"

#ifdef __cplusplus
}
#endif

#include "med_hdfi231.h"
#include "MAJ_231_232.h"

void MAJ_231_232_champs(med_idt fid)
{
  med_int ncomp,ncha;
  med_err lret,rett;
  med_type_champ typcha;
  char nomcha  [MED_TAILLE_NOM+1]="";
  char *comp, *unit;
  int i;

  /* combien de champs dans le fichier */
  ncha = MEDnChamp(fid,0);
  EXIT_IF(ncha < 0,"lors de la lecture du nombre de champs",NULL);

  /****************************************************************************
  *                       LECTURE DES CHAMPS                                  *
  ****************************************************************************/

  /* lecture de tous les champs  */
  for (i =0;i<ncha;i++) {
    lret = 0;

    /* Lecture du nombre de composantes */
    ncomp = MEDnChamp(fid,i+1);
    if (ncomp < 0) {
      MESSAGE("Erreur  la lecture du nombre de composantes : "); ISCRUTE(ncomp); 
      exit(1);
    }
    
    /* Lecture du type du champ, des noms des composantes et du nom de l'unit*/
    comp = (char*) malloc(ncomp*MED_TAILLE_PNOM+1);
    EXIT_IF(comp == NULL,NULL,NULL);
    unit = (char*) malloc(ncomp*MED_TAILLE_PNOM+1);
    EXIT_IF(unit == NULL,NULL,NULL);
      
    rett = MED231champInfoEtRen(fid,i+1,nomcha,&typcha,comp,unit,ncomp);
    if ( rett < 0 ) {
      MESSAGE("Erreur  la demande d'information sur les champs ");
      exit(1);
    }
      
    free(comp);
    free(unit);

      
    lret = MED231champNormaliser(fid, nomcha, typcha, ncomp, MED_NOEUD);
    if (lret != 0) {
      MESSAGE("Erreur  la lecture des champs aux noeuds "); exit(1);
    }

    lret = MED231champNormaliser(fid, nomcha, typcha, ncomp, MED_MAILLE);
    if (lret != 0) {
      MESSAGE("Erreur  la lecture des champs aux mailles "); exit(1);
    }

    lret = MED231champNormaliser(fid, nomcha, typcha, ncomp, MED_FACE);
    if (lret != 0) {
      MESSAGE("Erreur  la lecture des champs aux faces "); exit(1);
    }

    lret = MED231champNormaliser(fid, nomcha, typcha, ncomp, MED_ARETE);
    if (lret != 0) {
      MESSAGE("Erreur  la lecture des champs aux aretes "); exit(1);
    }
  }
}
