/*************************************************************************
* COPYRIGHT (C) 1999 - 2007  EDF R&D, CEA/DEN
* THIS LIBRARY IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
* IT UNDER THE TERMS OF THE GNU LESSER GENERAL PUBLIC LICENSE 
* AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
* EITHER VERSION 2.1 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
*  
* THIS LIBRARY IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
* WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
* MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
* LESSER GENERAL PUBLIC LICENSE FOR MORE DETAILS.
*
* YOU SHOULD HAVE RECEIVED A COPY OF THE GNU LESSER GENERAL PUBLIC LICENSE
* ALONG WITH THIS LIBRARY; IF NOT, WRITE TO THE FREE SOFTWARE FOUNDATION,
* INC., 59 TEMPLE PLACE, SUITE 330, BOSTON, MA 02111-1307 USA
*
*************************************************************************/

#include <med.h>
#include <med_config.h>
#include <med_outils.h> 
#include <string.h>
#include <stdlib.h>

/*
 * - Nom de la fonction : MEDchampEcr
 * - Description : ecriture d'un Champ Rsultat
 * - Parametres :
 *     - fid      (IN)  : ID du fichier HDF courant
 *     - maa      (IN)  : le nom du maillage sur lequel s'applique le champ (eventuellement distant)
 *     - cha      (IN)  : le nom du champ 
 *     - val      (IN)  : valeurs du champ  stocker
 *     - interlace(IN)  : entrelacement utilis en mmoire {MED_FULL_INTERLACE,MED_NO_INTERLACE} 
 *     - nbelem   (IN)  : nombre d'lments (prend en compte le nbre 
 *                         de points de Gauss (c'est demand  l'utilisateur ds la doc) 
                           mais pas le nbre de composantes)
 *     - locname  (IN)  : cl utilise pour la dfinition de la localisation 
                          des points de GAUSS (MED_NOGAUSS si aucun, MED_GAUSS_ELNO si les points de Gauss
 *                        portent sur les noeuds de l'element). La localisation doit exister 
 *                        avant l'appel  MEDchampEcr.
 *     - numco    (IN)  : n de la composante  stocker (MED_ALL si toutes)
 *     - profil   (IN)  : nom du profil utilis (MED_NOPFL si inutilis)
 *     - pflmod   (IN)  : Indique comment lire les informations en mmoire { MED_COMPACT, MED_GLOBAL }. 
 *     - type_ent (IN)  : entit concern par le champ {MED_NOEUD,MED_ARETE,MED_FACE,MED_MAILLE}
 *     - type_geo (IN)  : type gomtrique de l'entit concern {MED_POINT,MED_SEG2 ......}
 *     - numdt    (IN)  : n du pas de temps (MED_NOPDT si aucun)
 *     - dt_unit  (IN)  : chaine de taille MED_NOMP indiquant l'unit du champ
 *     - dt       (IN)  : valeur du pas de temps 
 *     - numo     (IN)  : n d'ordre utilis MED_NONOR si inutile
 * - Resultat : 0 en cas de succes, -1 sinon
 */ 

med_err MEDchampEcr(med_idt fid, char *maa, char *cha,
		    unsigned char *val, med_mode_switch interlace, med_int nbelem, char * locname, 
		    med_int numco, char * profil, med_mode_profil pflmod,
		    med_entite_maillage type_ent, med_geometrie_element type_geo,
		    med_int numdt,char * dt_unit, med_float dt, med_int numo)
{
  char *  name = "MEDchampEcr";
  int     dummy=0;
  med_err fret=-1;
  med_int majeur, mineur, release;
  MedFuncType func;

  MEDversionLire(fid, &majeur, &mineur, &release);
  
  func = _MEDversionedApi(name,majeur,mineur,release);
  if ( func != (MedFuncType) NULL )
    func (dummy, fid, maa, cha,
	  val, interlace, nbelem, locname,
	  numco, profil, pflmod,
	  type_ent, type_geo,
	  numdt, dt_unit, dt, numo , &fret);


  return fret;
}
