/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file BoxPlotBoxAttributes.cc
    \brief Implemtation of BoxPlotBox Attributes class.
    \author Graphics Section, ECMWF

    This file is automatically generated.
    Do Not Edit!
   
    Generated: Wed May  5 10:05:15 2010
*/    

#include "BoxPlotBoxAttributes.h"
#include "MagicsParameter.h"
#include "Factory.h"
#include "Translator.h"
#include "XmlNode.h"
#include "ParameterSettings.h"


using namespace magics;


BoxPlotBoxAttributes::BoxPlotBoxAttributes():
	colour_(Translator<string, Colour>().magics("boxplot_box_colour")),
	width_(ParameterManager::getDouble("boxplot_box_width")),
	border_(Translator<string, NoBoxPlotBoxBorder>().magics("boxplot_box_border")),
	median_(Translator<string, NoBoxPlotMedian>().magics("boxplot_median"))
{
} 



BoxPlotBoxAttributes::~BoxPlotBoxAttributes()
{
}

    
void BoxPlotBoxAttributes::set(const std::map<string, string>& params)
{
	vector<string> prefix(2);
	prefix[0] = "boxplot_box";
	prefix[1] = "boxplot";

	setAttribute(prefix, "boxplot_box_colour", colour_, params);
	setAttribute(prefix, "boxplot_box_width", width_, params);
	setMember(prefix, "boxplot_box_border", border_, params);
	setMember(prefix, "boxplot_median", median_, params);
}

void BoxPlotBoxAttributes::copy(const BoxPlotBoxAttributes& other)
{
	setColour(other.colour_->clone());
	width_ = other.width_;
	setBorder(other.border_->clone());
	setMedian(other.median_->clone());
} 


bool BoxPlotBoxAttributes::accept(const string& node)
{	
	if ( magCompare(node, "box")  )
		return true;

	if ( acceptNode(node, border_) )
		return true;

	if ( acceptNode(node, median_) )
		return true;
	return false;
}

void BoxPlotBoxAttributes::set(const XmlNode& node)
{
	if ( this->accept(node.name()) == false ) 
		return;

	if ( magCompare(node.name(), "box") )
		set(node.attributes());
	else {
		setMember(node.name(), border_, node);
		setMember(node.name(), median_, node);
	}
	for (XmlNode::ElementIterator elt = node.firstElement(); elt != node.lastElement(); ++elt) {
		setMember((*elt)->name(), border_, *(*elt)); 
		setMember((*elt)->name(), median_, *(*elt)); 
	}
}

void BoxPlotBoxAttributes::print(ostream& out)  const
{
	out << "BoxPlotBoxAttributes[";
	out << "colour = " << *colour_;
	out << ", width = " << width_;
	out << ", border = " << *border_;
	out << ", median = " << *median_;
	out << "]" << "\n";
}


void BoxPlotBoxAttributes::toxml(ostream& out, const string& tag, int tabs)  const
{
	string tab;
	for ( int t = 0; t < tabs; t++) tab = tab + "	";
	
	out << tab << "<" << tag << "\n";
	out << tab << "\tboxplot_box_colour = \'" << *colour_ << "\'\n";
	out << tab << "\tboxplot_box_width = \'" << width_ << "\'\n";
	out << tab << ">";

 	border_->toxml(out, tabs+1);
 	median_->toxml(out, tabs+1);

	out << tab << "</" << tag << ">\n";
}

static MagicsParameter<string> boxplot_box_colour("boxplot_box_colour", "sky", "");
static MagicsParameter<double> boxplot_box_width("boxplot_box_width", 1.0, "");
static MagicsParameter<string> boxplot_box_border("boxplot_box_border", "on", "");
static MagicsParameter<string> boxplot_median("boxplot_median", "on", "");
#include "BoxPlotItem.h"
#include "BoxPlotBasicItem.h"
static SimpleObjectMaker<BoxPlotBoxBorder, NoBoxPlotBoxBorder> on_BoxPlotBoxBorder("on");
static SimpleObjectMaker<BoxPlotBoxBorder, NoBoxPlotBoxBorder> border_BoxPlotBoxBorder("border");
static SimpleObjectMaker<NoBoxPlotBoxBorder, NoBoxPlotBoxBorder> off_NoBoxPlotBoxBorder("off");
static SimpleObjectMaker<NoBoxPlotBoxBorder, NoBoxPlotBoxBorder> noborder_NoBoxPlotBoxBorder("noborder");
#include "BoxPlotItem.h"
#include "BoxPlotBasicItem.h"
static SimpleObjectMaker<BoxPlotMedian, NoBoxPlotMedian> on_BoxPlotMedian("on");
static SimpleObjectMaker<BoxPlotMedian, NoBoxPlotMedian> median_BoxPlotMedian("median");
static SimpleObjectMaker<NoBoxPlotMedian, NoBoxPlotMedian> off_NoBoxPlotMedian("off");
static SimpleObjectMaker<NoBoxPlotMedian, NoBoxPlotMedian> nomedian_NoBoxPlotMedian("nomedian");
