/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xsl.tr;

import com.jclark.xsl.om.NamespacePrefixMap;
import com.jclark.xsl.om.Node;
import com.jclark.xsl.om.XSLException;
import com.jclark.xsl.sax.MultiNamespaceResult;
import com.jclark.xsl.sax.SaxFilterMaker;
import com.jclark.xsl.tr.Action;
import com.jclark.xsl.tr.ContentHandlingResultWriter;
import com.jclark.xsl.tr.ProcessContext;
import com.jclark.xsl.tr.Result;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLFilter;
import org.xml.sax.helpers.ParserAdapter;
import org.xml.sax.helpers.XMLFilterImpl;

class XRAPAction
implements Action {
    private Action _content;
    private NamespacePrefixMap _nsMap;

    XRAPAction(NamespacePrefixMap nsMap, Action content) {
        this._nsMap = nsMap;
        this._content = content;
    }

    public void invoke(ProcessContext context, Node sourceNode, Result result) throws XSLException {
        ResultReaderAdapter xrapInputReader = new ResultReaderAdapter(context, this._content, sourceNode);
        SaxFilterMaker fm = context.getSaxExtensionFilter();
        if (fm == null) {
            throw new XSLException("XRAPAction::no SaxFilterMaker");
        }
        XMLFilter filt = fm.getFilter();
        filt.setParent(xrapInputReader);
        ContentHandlingResultWriter chrw = new ContentHandlingResultWriter(this._nsMap.getNameTable().getEmptyNamespacePrefixMap(), filt, result);
        filt.setContentHandler(chrw);
        try {
            filt.parse("dummy");
        }
        catch (Exception ex) {
            throw new XSLException(ex);
        }
    }

    private class ResultReaderAdapter
    extends XMLFilterImpl {
        Action _content;
        ProcessContext _context;
        Node _sourceNode;
        Result _xrapEventProcessor;
        ParserAdapter _parserAdapter;
        private ContentHandler _handler;

        ResultReaderAdapter(ProcessContext context, Action content, Node sourceNode) {
            this._context = context;
            this._content = content;
            this._sourceNode = sourceNode;
        }

        public void setContentHandler(ContentHandler xrapProcessor) {
            try {
                this._parserAdapter = new ParserAdapter();
            }
            catch (SAXException sAXException) {
                // empty catch block
            }
            this._parserAdapter.setContentHandler(xrapProcessor);
            this._xrapEventProcessor = new MultiNamespaceResult(this._parserAdapter, null);
        }

        public void parse(String sysid) throws SAXException {
            this.process();
        }

        public void parse(InputSource src) throws SAXException {
            this.process();
        }

        private void process() throws SAXException {
            try {
                super.startDocument();
                this._content.invoke(this._context, this._sourceNode, this._xrapEventProcessor);
                super.endDocument();
            }
            catch (XSLException ex) {
                throw new SAXException(ex);
            }
        }
    }
}

