/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xsl.tr;

import com.jclark.xsl.expr.ExprContext;
import com.jclark.xsl.expr.Variant;
import com.jclark.xsl.expr.VariantExpr;
import com.jclark.xsl.om.Name;
import com.jclark.xsl.om.Node;
import com.jclark.xsl.om.XSLException;
import com.jclark.xsl.tr.Action;

abstract class ParamAction
implements Action {
    private Name[] paramNames = null;
    private VariantExpr[] paramExprs = null;

    ParamAction() {
    }

    void addParam(Name name, VariantExpr expr) {
        if (this.paramNames == null) {
            this.paramNames = new Name[]{name};
            this.paramExprs = new VariantExpr[]{expr};
        } else {
            Name[] oldParamNames = this.paramNames;
            this.paramNames = new Name[oldParamNames.length + 1];
            System.arraycopy(oldParamNames, 0, this.paramNames, 0, oldParamNames.length);
            this.paramNames[oldParamNames.length] = name;
            VariantExpr[] oldParamExprs = this.paramExprs;
            this.paramExprs = new VariantExpr[oldParamExprs.length + 1];
            System.arraycopy(oldParamExprs, 0, this.paramExprs, 0, oldParamExprs.length);
            this.paramExprs[oldParamExprs.length] = expr;
        }
    }

    Name[] getParamNames() {
        return this.paramNames;
    }

    Variant[] getParamValues(Node sourceNode, ExprContext context) throws XSLException {
        if (this.paramExprs == null) {
            return null;
        }
        Variant[] paramValues = new Variant[this.paramExprs.length];
        for (int i = 0; i < paramValues.length; ++i) {
            paramValues[i] = this.paramExprs[i].eval(sourceNode, context).makePermanent();
        }
        return paramValues;
    }
}

