/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xsl.expr;

import com.jclark.xsl.expr.ConvertibleExpr;
import com.jclark.xsl.expr.ConvertibleStringExpr;
import com.jclark.xsl.expr.ExprContext;
import com.jclark.xsl.expr.Function;
import com.jclark.xsl.expr.ParseException;
import com.jclark.xsl.om.Node;
import com.jclark.xsl.om.XSLException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

class RegexpReplaceFunction
implements Function {
    RegexpReplaceFunction() {
    }

    public ConvertibleExpr makeCallExpr(ConvertibleExpr[] args, Node exprNode) throws ParseException {
        if (args.length != 4) {
            throw new ParseException("expected 4 arguments");
        }
        final ConvertibleStringExpr se = args[0].makeStringExpr();
        final ConvertibleStringExpr se2 = args[1].makeStringExpr();
        final ConvertibleStringExpr se3 = args[2].makeStringExpr();
        final ConvertibleStringExpr se4 = args[3].makeStringExpr();
        return new ConvertibleStringExpr(){

            public String eval(Node node, ExprContext context) throws XSLException {
                return RegexpReplaceFunction.replace(node, context, se.eval(node, context), se2.eval(node, context), se3.eval(node, context), se4.eval(node, context));
            }
        };
    }

    private static final String replace(Node node, ExprContext context, String src, String pattern, String flags, String replaceStr) throws XSLException {
        try {
            Pattern pat;
            Matcher matcher;
            boolean globalReplace = false;
            boolean ignoreCase = false;
            if (flags.length() > 0) {
                globalReplace = flags.indexOf("g") >= 0;
                ignoreCase = flags.indexOf("i") >= 0;
            }
            if ((matcher = (pat = ignoreCase ? Pattern.compile(pattern, 2) : Pattern.compile(pattern)).matcher(src)).find()) {
                int gc = matcher.groupCount();
                return globalReplace ? matcher.replaceAll(replaceStr) : matcher.replaceFirst(replaceStr);
            }
            return src;
        }
        catch (PatternSyntaxException ex) {
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }
}

