/*
 * libsysactivity
 * http://sourceforge.net/projects/libsysactivity/
 * Copyright (c) 2009, 2010 Carlos Olmedo Escobar <carlos.olmedo.e@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <stdio.h>
#include <unistd.h>
#include <pthread.h>
#include <stdint.h>
#include <stdlib.h>
#include <string.h>
#include <inttypes.h>

#include <libsysactivity/libsysactivity.h>

void* stress_get_memory(void* arg) {
	int i;
	int ret;
	struct sa_memory memory;

#ifdef SA_OPEN_MEMORY
	ret = sa_open_memory();
	if (ret != 0) {
		printf("sa_open_memory(): %s\n", strerror(ret));
		exit(EXIT_FAILURE);
	}
#endif

	for (i = 0; i < 100000; i++) {
		ret = sa_get_memory(&memory);
		if (ret != 0) {
			printf("sa_get_memory(): %s\n", strerror(ret));
			exit(EXIT_FAILURE);
		}
	}

#ifdef SA_CLOSE_MEMORY
	ret = sa_close_memory();
	if (ret != 0) {
		printf("sa_close_memory(): %s\n", strerror(ret));
		exit(EXIT_FAILURE);
	}
#endif
	return NULL;
}

void* stress_get_swaps(void* arg) {
	int i;
	int ret;

#ifdef SA_OPEN_MEMORY
	ret = sa_open_memory();
	if (ret != 0) {
		printf("sa_open_memory(): %s\n", strerror(ret));
		exit(EXIT_FAILURE);
	}
#endif

	struct sa_swap swap;
	ret = sa_get_swap(0, &swap);
	if (ret != 0) {
		printf("sa_get_swap(): %s\n", strerror(ret));
		exit(EXIT_FAILURE);
	}

	uint16_t number_swaps = 0;
	ret = sa_count_swaps(&number_swaps);
	if (ret != 0) {
		printf("sa_count_swaps(): %s\n", strerror(ret));
		exit(EXIT_FAILURE);
	}

	struct sa_swap* swaps = (struct sa_swap*) malloc(number_swaps * sizeof(struct sa_swap));
	for (i = 0; i < 1500000; i++) {
		uint16_t written = 0;
		sa_get_swaps(swaps, number_swaps, &written);
	}
	free(swaps);

#ifdef SA_CLOSE_MEMORY
	ret = sa_close_memory();
	if (ret != 0) {
		printf("sa_close_memory(): %s\n", strerror(ret));
		exit(EXIT_FAILURE);
	}
#endif
	return NULL;
}

int main() {
	pthread_t thread1;
	struct timespec delay;
	delay.tv_sec = 0;
	delay.tv_nsec = 1000000;

	pthread_create(&thread1, NULL, stress_get_memory, NULL);
	nanosleep(&delay, NULL);
	stress_get_memory(NULL);

	return EXIT_SUCCESS;
}
