#!/bin/bash

if [ $# -ne 1 ]
then
	echo "Usage: `basename $0` {version}"
	exit 1
fi

DOTTED_VERSION=$1
SLASHED_VERSION=$(echo $DOTTED_VERSION|sed 's/\./_/g')
WORKING_DIR="`pwd`/libsysactivity$RANDOM"

clean () {
	cd $WORKING_DIR
	cd ..
	rm -rf $WORKING_DIR
}

mkdir $WORKING_DIR
cd $WORKING_DIR
cvs -d:pserver:anonymous@libsysactivity.cvs.sourceforge.net:/cvsroot/libsysactivity export -r libsysactivity-$SLASHED_VERSION -d libsysactivity-$DOTTED_VERSION libsysactivity

grep LIBSA_VERSION libsysactivity-$DOTTED_VERSION/CMakeLists.txt
read -p "Have you updated the CMakeList.txt version? (y/n) " yn
if	[ $yn != "y" ]; then
	clean
	exit 2
fi

grep SA_VERSION_ libsysactivity-$DOTTED_VERSION/src/common/cpu.h
read -p "Have you updated the version in cpu.h? (y/n) " yn
if	[ $yn != "y" ]; then
	clean
	exit 2
fi

grep PROJECT_NUMBER libsysactivity-$DOTTED_VERSION/Doxyfile
read -p "Have you updated the Doxyfile version? (y/n) " yn
if	[ $yn != "y" ]; then
	clean
	exit 2
fi

cat libsysactivity-$DOTTED_VERSION/cmake/libsysactivityConfigVersion.cmake
read -p "Have you updated the libsysactivityConfigVersion.cmake? (always needed) (y/n) " yn
if	[ $yn != "y" ]; then
	clean
	exit 2
fi

head libsysactivity-$DOTTED_VERSION/CHANGELOG
read -p "Have you updated the changelog? (y/n) " yn
if	[ $yn != "y" ]; then
	clean
	exit 2
fi

mkdir $WORKING_DIR/libsysactivity-$DOTTED_VERSION/build/

cd $WORKING_DIR/libsysactivity-$DOTTED_VERSION/build/
cmake .. -DCMAKE_BUILD_TYPE=release && make
if	[ $? != 0 ]; then
	echo "ERROR: Can't compile the CVS code."
	clean
	exit 3
fi

make install
if	[ $? != 0 ]; then
	sudo make install
fi

make -f test/Makefile all && make test
if	[ $? != 0 ]; then
	echo "ERROR: Unit tests not passed."
	clean
	exit 4
fi
rm -rf $WORKING_DIR/libsysactivity-$DOTTED_VERSION/build/*

cd $WORKING_DIR
tar -zcvf libsysactivity-$DOTTED_VERSION.tar.gz libsysactivity-$DOTTED_VERSION
mv libsysactivity-$DOTTED_VERSION.tar.gz ..
clean
