/*
 * libsyncml - A syncml protocol implementation
 * Copyright (C) 2005  Armin Bauer <armin.bauer@opensync.org>
 * Copyright (C) 2007-2009  Michael Bell <michael.bell@opensync.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *
 */

/**
 * @defgroup SmlDefines SyncML Defines
 * @ingroup PublicLowLevelAPI
 * @brief The public part
 * 
 */
/*@{*/

#ifndef _SML_DEFINES_H
#define _SML_DEFINES_H

#define SML_ELEMENT_SYNCML "SyncML"
#define SML_ELEMENT_SYNCHDR "SyncHdr"
#define SML_ELEMENT_SYNCBODY "SyncBody"
#define SML_ELEMENT_VERPROTO "VerProto"
#define SML_ELEMENT_VERDTD "VerDTD"
#define SML_ELEMENT_MSGID "MsgID"
#define SML_ELEMENT_SESSIONID "SessionID"
#define SML_ELEMENT_TARGET "Target"
#define SML_ELEMENT_SOURCE "Source"
#define SML_ELEMENT_SOURCE_PARENT "SourceParent"
#define SML_ELEMENT_TARGET_PARENT "TargetParent"
#define SML_ELEMENT_LOCURI "LocURI"
#define SML_ELEMENT_LOCNAME "LocName"
#define SML_ELEMENT_RESPURI "RespURI"
#define SML_ELEMENT_NORESP "NoResp"
#define SML_ELEMENT_SYNC "Sync"
#define SML_ELEMENT_STATUS "Status"
#define SML_ELEMENT_CMDID "CmdID"
#define SML_ELEMENT_MSGREF "MsgRef"
#define SML_ELEMENT_CMDREF "CmdRef"
#define SML_ELEMENT_CMD "Cmd"
#define SML_ELEMENT_ANCHOR "Anchor"
#define SML_ELEMENT_NEXT "Next"
#define SML_ELEMENT_LAST "Last"
#define SML_ELEMENT_ALERT "Alert"
#define SML_ELEMENT_PUT "Put"
#define SML_ELEMENT_GET "Get"
#define SML_ELEMENT_SEQUENCE "Sequence"
#define SML_ELEMENT_ATOMIC "Atomic"
#define SML_ELEMENT_FINAL "Final"
#define SML_ELEMENT_DATA "Data"
#define SML_ELEMENT_ITEM "Item"
#define SML_ELEMENT_META "Meta"
#define SML_ELEMENT_MAXMSGSIZE "MaxMsgSize"
#define SML_ELEMENT_TYPE "Type"
#define SML_ELEMENT_SOURCEREF "SourceRef"
#define SML_ELEMENT_TARGETREF "TargetRef"
#define SML_ELEMENT_NUMBEROFCHANGES "NumberOfChanges"
#define SML_ELEMENT_ADD "Add"
#define SML_ELEMENT_REPLACE "Replace"
#define SML_ELEMENT_DELETE "Delete"
#define SML_ELEMENT_MAP "Map"
#define SML_ELEMENT_MAPITEM "MapItem"
#define SML_ELEMENT_FORMAT "Format"
#define SML_ELEMENT_CRED "Cred"
#define SML_ELEMENT_CHAL "Chal"
#define SML_ELEMENT_RESULTS "Results"
#define SML_ELEMENT_MAXOBJSIZE "MaxObjSize"
#define SML_ELEMENT_EMI "EMI"
#define SML_ELEMENT_MOREDATA "MoreData"
#define SML_ELEMENT_MEM "Mem"
#define SML_ELEMENT_FREEID "FreeID"
#define SML_ELEMENT_VERSION "Version"
#define SML_ELEMENT_NEXTNONCE "NextNonce"

/* For devinf */
#define SML_ELEMENT_CTCAP "CTCap"
#define SML_ELEMENT_CTTYPE "CTType"
#define SML_ELEMENT_DATASTORE "DataStore"
#define SML_ELEMENT_DATATYPE "DataType"
#define SML_ELEMENT_DEVID "DevID"
#define SML_ELEMENT_DEVINF "DevInf"
#define SML_ELEMENT_DEVTYPE "DevTyp"
#define SML_ELEMENT_DISPLAYNAME "DisplayName"
#define SML_ELEMENT_DSMEM "DSMem"
#define SML_ELEMENT_EXT "Ext"
#define SML_ELEMENT_FWV "FwV"
#define SML_ELEMENT_HWV "HwV"
#define SML_ELEMENT_MAN "Man"
#define SML_ELEMENT_MAXGUIDSIZE "MaxGUIDSize"
#define SML_ELEMENT_MAXID "MaxID"
#define SML_ELEMENT_MAXMEM "MaxMem"
#define SML_ELEMENT_MAXOCCUR "MaxOccur"
#define SML_ELEMENT_MAXSIZE "MaxSize"
#define SML_ELEMENT_MOD "Mod"
#define SML_ELEMENT_NOTRUNCATE "NoTruncate"
#define SML_ELEMENT_OEM "OEM"
#define SML_ELEMENT_PARAMNAME "ParamName"
#define SML_ELEMENT_PROPERTY "Property"
#define SML_ELEMENT_PROPNAME "PropName"
#define SML_ELEMENT_PROPPARAM "PropParam"
#define SML_ELEMENT_RX "Rx"
#define SML_ELEMENT_RXPREF "Rx-Pref"
#define SML_ELEMENT_SHAREDMEM "SharedMem"
#define SML_ELEMENT_SIZE "Size"
#define SML_ELEMENT_SUPPORTLARGEOBJS "SupportLargeObjs"
#define SML_ELEMENT_SUPPORTNUMBEROFCHANGES "SupportNumberOfChanges"
#define SML_ELEMENT_SUPPORT_HIERARCHICAL_SYNC "SupportHierarchicalSync"
#define SML_ELEMENT_SWV "SwV"
#define SML_ELEMENT_SYNCCAP "SyncCap"
#define SML_ELEMENT_SYNCTYPE "SyncType"
#define SML_ELEMENT_TX "Tx"
#define SML_ELEMENT_TXPREF "Tx-Pref"
#define SML_ELEMENT_UTC "UTC"
#define SML_ELEMENT_VALENUM "ValEnum"
#define SML_ELEMENT_VERCT "VerCT"
#define SML_ELEMENT_XNAM "XNam"
#define SML_ELEMENT_XVAL "XVal"

/* For metinf */
#define SML_ELEMENT_MARK "Mark"

#define SML_ELEMENT_DATATYPE_CHR "chr"
#define SML_ELEMENT_DATATYPE_INT "int"
#define SML_ELEMENT_DATATYPE_BOOL "bool"
#define SML_ELEMENT_DATATYPE_BIN "bin"
#define SML_ELEMENT_DATATYPE_DATE "datetime"
#define SML_ELEMENT_DATATYPE_PHONE "phonenum"

#define SML_ELEMENT_DEVTYP_PAGER "pager"
#define SML_ELEMENT_DEVTYP_HANDHELD "handheld"
#define SML_ELEMENT_DEVTYP_PDA "pda"
#define SML_ELEMENT_DEVTYP_PHONE "phone"
#define SML_ELEMENT_DEVTYP_SMARTPHONE "smartphone"
#define SML_ELEMENT_DEVTYP_SERVER "server"
#define SML_ELEMENT_DEVTYP_WORKSTATION "workstation"

typedef enum {
	SML_DEVINF_DATATYPE_UNKNOWN,
	SML_DEVINF_DATATYPE_CHR,
	SML_DEVINF_DATATYPE_INT,
	SML_DEVINF_DATATYPE_BOOL,
	SML_DEVINF_DATATYPE_BIN,
	SML_DEVINF_DATATYPE_DATE,
	SML_DEVINF_DATATYPE_PHONE
} SmlDevInfDataType;

typedef enum {
	SML_DEVINF_DEVTYPE_UNKNOWN,
	SML_DEVINF_DEVTYPE_PAGER,
	SML_DEVINF_DEVTYPE_HANDHELD,
	SML_DEVINF_DEVTYPE_PDA,
	SML_DEVINF_DEVTYPE_PHONE,
	SML_DEVINF_DEVTYPE_SMARTPHONE,
	SML_DEVINF_DEVTYPE_SERVER,
	SML_DEVINF_DEVTYPE_WORKSTATION
} SmlDevInfDevTyp;

typedef enum {
	SML_DEVINF_SYNCTYPE_UNKNOWN = 0,
	SML_DEVINF_SYNCTYPE_TWO_WAY = 1,
	SML_DEVINF_SYNCTYPE_SLOW_SYNC = 1 << 1,
	SML_DEVINF_SYNCTYPE_ONE_WAY_FROM_CLIENT = 1 << 2,
	SML_DEVINF_SYNCTYPE_REFRESH_FROM_CLIENT = 1 << 3,
	SML_DEVINF_SYNCTYPE_ONE_WAY_FROM_SERVER = 1 << 4,
	SML_DEVINF_SYNCTYPE_REFRESH_FROM_SERVER = 1 << 5,
	SML_DEVINF_SYNCTYPE_SERVER_ALERTED_SYNC = 1 << 6
} SmlDevInfSyncCap;

typedef enum {
	SML_DEVINF_CTCAP_UNKNOWN,
	SML_DEVINF_CTCAP_CTTYPE,
	SML_DEVINF_CTCAP_PROPNAME,
	SML_DEVINF_CTCAP_VALENUM,
	SML_DEVINF_CTCAP_DATATYPE,
	SML_DEVINF_CTCAP_SIZE,
	SML_DEVINF_CTCAP_DISPLAYNAME,
	SML_DEVINF_CTCAP_PARAMNAME,
	SML_DEVINF_CTCAP_VERCT,
	SML_DEVINF_CTCAP_PROPERTY,
	SML_DEVINF_CTCAP_PROPPARAM,
	SML_DEVINF_CTCAP_NOTRUNCATE,
	SML_DEVINF_CTCAP_MAXOCCUR,
	SML_DEVINF_CTCAP_MAXSIZE
} SmlDevInfCTCapType;

#define SML_ELEMENT_TEXT_VCARD "text/x-vcard"
#define SML_ELEMENT_TEXT_VCARD_30 "text/vcard"
#define SML_ELEMENT_TEXT_VCAL "text/x-vcalendar"
#define SML_ELEMENT_TEXT_ICAL "text/calendar"
#define SML_ELEMENT_TEXT_PLAIN "text/plain"
#define SML_ELEMENT_TEXT_MESSAGE "text/x-vMessage"

#define SML_ELEMENT_DEVINF_XML "application/vnd.syncml-devinf+xml"
#define SML_ELEMENT_WBXML "application/vnd.syncml+wbxml"
#define SML_ELEMENT_XML "application/vnd.syncml+xml"
#define SML_ELEMENT_SAN "application/vnd.syncml.ds.notification"
#define SML_ELEMENT_APPLICATION_OMA_DS_EMAIL "application/vnd.omads-email+xml"
#define SML_ELEMENT_APPLICATION_OMA_DS_FILE "application/vnd.omads-file+xml"
#define SML_ELEMENT_APPLICATION_OMA_DS_FOLDER "application/vnd.omads-folder+xml"

#define SML_NAMESPACE_METINF "syncml:metinf"
#define SML_NAMESPACE_DEVINF "syncml:devinf"
#define SML_NAMESPACE_SYNCML10 "SYNCML:SYNCML1.0"
#define SML_NAMESPACE_SYNCML11 "SYNCML:SYNCML1.1"
#define SML_NAMESPACE_SYNCML12 "SYNCML:SYNCML1.2"

#define SML_VERSION_STRING_10 "SyncML/1.0"
#define SML_VERSION_STRING_11 "SyncML/1.1"
#define SML_VERSION_STRING_12 "SyncML/1.2"

#define SML_AUTH_BASIC "syncml:auth-basic"
#define SML_AUTH_MD5 "syncml:auth-md5"
#define SML_BASE64 "b64"

/* Transport configuration defines */

#define SML_TRANSPORT_CONFIG_PROXY             "PROXY"
#define SML_TRANSPORT_CONFIG_USERNAME          "USERNAME"
#define SML_TRANSPORT_CONFIG_PASSWORD          "PASSWORD"
#define SML_TRANSPORT_CONFIG_SSL_CA_FILE       "SSL_CA_FILE"
#define SML_TRANSPORT_CONFIG_PORT              "PORT"
#define SML_TRANSPORT_CONFIG_URL               "URL"
#define SML_TRANSPORT_CONFIG_SSL_KEY           "SSL_KEY"
#define SML_TRANSPORT_CONFIG_SSL_SERVER_CERT   "SSL_SERVER_CERT"
#define SML_TRANSPORT_CONFIG_BLUETOOTH_ADDRESS "BLUETOOTH_ADDRESS"
#define SML_TRANSPORT_CONFIG_BLUETOOTH_CHANNEL "BLUETOOTH_CHANNEL"
#define SML_TRANSPORT_CONFIG_IRDA_SERVICE      "IRDA_SERVICE"

#define SML_TRANSPORT_CONFIG_AT_COMMAND      "AT_COMMAND"
#define SML_TRANSPORT_CONFIG_AT_MANUFACTURER "AT_MANUFACTURER"
#define SML_TRANSPORT_CONFIG_AT_MODEL        "AT_MODEL"

#define SML_TRANSPORT_CONFIG_DATASTORE         "DATASTORE"
#define SML_TRANSPORT_CONFIG_DATASTORE_EVENT   "EVENT"
#define SML_TRANSPORT_CONFIG_DATASTORE_TODO    "TODO"
#define SML_TRANSPORT_CONFIG_DATASTORE_CONTACT "CONTACT"
#define SML_TRANSPORT_CONFIG_DATASTORE_NOTE    "NOTE"

/* Enumeration types */

typedef enum  {
	SML_DEVINF_VERSION_UNKNOWN = 0,
	SML_DEVINF_VERSION_10 = 1,
	SML_DEVINF_VERSION_11 = 2,
	SML_DEVINF_VERSION_12 = 3
} SmlDevInfVersion;

typedef enum {
	SML_MIMETYPE_UNKNOWN,
	SML_MIMETYPE_XML,
	SML_MIMETYPE_WBXML,
	SML_MIMETYPE_SAN
} SmlMimeType;

typedef enum {
	SML_TRANSPORT_HTTP_SERVER,
	SML_TRANSPORT_HTTP_CLIENT,
	SML_TRANSPORT_OBEX_CLIENT,
	SML_TRANSPORT_OBEX_SERVER
} SmlTransportType;

typedef enum {
	SML_RESULT_OK,
	SML_RESULT_RETRY,
	SML_RESULT_FATAL
} SmlTransportResult;

typedef enum {
	SML_VERSION_UNKNOWN = 0,
	SML_VERSION_10 = 1,
	SML_VERSION_11 = 2,
	SML_VERSION_12 = 3
} SmlProtocolVersion;

typedef enum {
	SML_PROTOCOL_UNKNOWN = 0,
	SML_PROTOCOL_SYNCML = 1,
	SML_PROTOCOL_DM = 2
} SmlProtocolType;

typedef enum {
	SML_COMMAND_TYPE_UNKNOWN = 0,
	SML_COMMAND_TYPE_ALERT = 1,
	SML_COMMAND_TYPE_SYNC = 2,
	SML_COMMAND_TYPE_PUT = 3,
	SML_COMMAND_TYPE_HEADER = 4,
	SML_COMMAND_TYPE_ADD = 5,
	SML_COMMAND_TYPE_REPLACE = 6,
	SML_COMMAND_TYPE_DELETE = 7,
	SML_COMMAND_TYPE_MAP = 8,
	SML_COMMAND_TYPE_GET = 9,
	SML_COMMAND_TYPE_RESULTS = 10
} SmlCommandType;

typedef enum {
	SML_ALERT_UNKNOWN = 0,
	SML_ALERT_DISPLAY = 100,
	SML_ALERT_TWO_WAY = 200,
	SML_ALERT_SLOW_SYNC = 201,
	SML_ALERT_ONE_WAY_FROM_CLIENT = 202,
	SML_ALERT_REFRESH_FROM_CLIENT = 203,
	SML_ALERT_ONE_WAY_FROM_SERVER = 204,
	SML_ALERT_REFRESH_FROM_SERVER = 205,
	SML_ALERT_TWO_WAY_BY_SERVER = 206,
	SML_ALERT_ONE_WAY_FROM_CLIENT_BY_SERVER = 207,
	SML_ALERT_REFRESH_FROM_CLIENT_BY_SERVER = 208,
	SML_ALERT_ONE_WAY_FROM_SERVER_BY_SERVER = 209,
	SML_ALERT_REFRESH_FROM_SERVER_BY_SERVER = 210,
	SML_ALERT_RESULT = 221,
	SML_ALERT_NEXT_MESSAGE = 222,
	SML_ALERT_NO_END_OF_DATA = 223
} SmlAlertType;

typedef enum {
	SML_CHANGE_UNKNOWN = 0,
	SML_CHANGE_ADD = 1,
	SML_CHANGE_REPLACE = 2,
	SML_CHANGE_DELETE = 3
} SmlChangeType;

typedef enum {
	SML_AUTH_TYPE_UNKNOWN = 0,
	SML_AUTH_TYPE_BASIC = 1,
	SML_AUTH_TYPE_MD5 = 2
} SmlAuthType;

typedef enum {
	SML_FORMAT_TYPE_UNKNOWN = 0,
	SML_FORMAT_TYPE_BASE64 = 1
} SmlFormatType;

typedef enum {
	SML_DS_UNKNOWN_TYPE = 0,
	SML_DS_SERVER = 1,
	SML_DS_CLIENT = 2
} SmlDsServerType;

#if __GNUC__ - 0 > 3 || (__GNUC__ - 0 == 3 && __GNUC_MINOR__ - 0 >= 2)
  /* gcc >= 3.2 */
# define LIBSYNCML_DEPRECATED __attribute__ ((deprecated))
#elif defined(_MSC_VER) && (_MSC_VER >= 1300) && (_MSC_VER < 1400)
  /* msvc >= 7 */
# define LIBSYNCML_DEPRECATED __declspec(deprecated)
#elif defined(_MSV_VER) && (_MSC_VER >= 1400)
  /* MS Visual Studio 2005 */
# define LIBSYNCML_DEPRECATED
#else
# define LIBSYNCML_DEPRECATED
#endif

#endif //_SML_DEFINES_H

/*@}*/
