/* ToVariousMenus.java
 * =========================================================================
 * This file is part of the SWIRL Library - http://swirl-lib.sourceforge.net
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 * 
 */

package be.ugent.caagt.swirl.menus;

import be.ugent.caagt.swirl.actions.Description;
import be.ugent.caagt.swirl.actions.MenuButton;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonModel;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JRadioButtonMenuItem;

/**
 * Common super class of the visitors that build menulike
 * components.
 */
abstract class ToVariousMenus extends MenuBuilderVisitor {
    
    //
    protected JComponent parent;

    public void setParent(JComponent parent) {
        this.parent = parent;
    }

    public ToVariousMenus(MenuBuilder builder) {
        super(builder);
    }

    protected AbstractButton addAction(Action action) {
        AbstractButton button = new MenuButton(action);
        parent.add(button);
        return button;
    }

    protected AbstractButton addButton(Description description) {
        AbstractButton button = new JRadioButtonMenuItem();
        description.init(button);
        parent.add(button);
        return button;
    }

    protected AbstractButton addToggle(ButtonModel model, Description description) {
        AbstractButton button = new JCheckBoxMenuItem();
        button.setModel(model);
        description.init(button);
        parent.add(button);
        return button;
    }

}
