#include "osl/threatmate/kfendPredictor.h"
#include "osl/record/csaString.h"

#include <cppunit/TestCase.h>
#include <cppunit/extensions/HelperMacros.h>

using namespace osl;
using namespace osl::threatmate;

class KfendPredictorTest : public CppUnit::TestFixture 
{
  CPPUNIT_TEST_SUITE(KfendPredictorTest);

  CPPUNIT_TEST(testBeginning);
  CPPUNIT_TEST(testAddEffect);
  CPPUNIT_TEST(testNotAddEffect);
  CPPUNIT_TEST(testCheck);
  CPPUNIT_TEST(testChecked);
  // CPPUNIT_TEST(testXXX);

  CPPUNIT_TEST_SUITE_END();
public:
  void testBeginning();
  void testAddEffect();
  void testNotAddEffect();
  void testCheck();
  void testChecked();
  // void testXXX() { CPPUNIT_ASSERT(1+1 == 2); }

};

CPPUNIT_TEST_SUITE_REGISTRATION(KfendPredictorTest);

void KfendPredictorTest::testBeginning()
{
  const NumEffectState state((SimpleState(HIRATE)));
  const Move move = Move(Position(3,3), PAWN, WHITE);
  KfendPredictor Kfend;
  CPPUNIT_ASSERT( !Kfend.predict(state, move) );
}

void KfendPredictorTest::testAddEffect()
{
  const NumEffectState state(CsaString(
				       "P1-KY *  * +TO * +KA-OU-KE-KY\n"
				       "P2-KY *  *  * +HI-KI *  *  * \n"
				       "P3 *  * -KE *  * -FU-FU-FU * \n"
				       "P4 * -FU-FU *  *  *  * -KI-FU\n"
				       "P5-FU *  *  * +FU *  *  *  * \n"
				       "P6 *  * +FU-HI *  *  * +KI * \n"
				       "P7+FU+FU+KE * -TO-NK+FU *  * \n"
				       "P8+OU * +GI *  *  *  *  *  * \n"
				       "P9+KY * -TO *  *  *  *  *  * \n"
				       "P+00KI00FU\n"
				       "P-00KA00GI00GI00GI00FU00FU\n"
				       "-\n").getInitialState());
  const Move move = Move(Position(5,2), ROOK, BLACK);
  KfendPredictor Kfend;
  CPPUNIT_ASSERT( Kfend.predict(state, move) );
}

void KfendPredictorTest::testNotAddEffect()
{
  const NumEffectState state(CsaString(
				       "P1+RY-KE-FU * +NK *  * -OU-FU\n"
				       "P2 *  * -GI *  * +KI *  *  * \n"
				       "P3 *  *  *  *  *  *  *  * +GI\n"
				       "P4+FU *  *  * -KY+GI-KY * +FU\n"
				       "P5 * -FU *  *  *  *  *  * -KE\n"
				       "P6 *  * +FU *  *  * +KA-UM * \n"
				       "P7 * +FU *  *  *  * -KY+KY-GI\n"
				       "P8 *  *  *  *  * -KI *  *  * \n"
				       "P9-RY+KE+KI *  *  *  * +KI+OU\n"
				       "P+00FU00FU00FU00FU00FU\n"
				       "P-00FU00FU00FU00FU00FU00FU\n"
				       "-\n").getInitialState());
  const Move move = Move(Position(3,6), BISHOP, BLACK);
  KfendPredictor Kfend;
  CPPUNIT_ASSERT( !Kfend.predict(state, move) );
}

void KfendPredictorTest::testCheck()
{
  const NumEffectState state(CsaString(
				       "P1+RY-KE-FU * +NK *  * -OU-FU\n"
				       "P2 *  * -GI *  * +KI *  *  * \n"
				       "P3 *  *  *  *  *  *  * +KY+GI\n"
				       "P4+FU *  *  * -UM+GI-KY * +FU\n"
				       "P5 * -FU *  *  *  *  *  * -KE\n"
				       "P6 *  * +FU *  *  *  *  *  * \n"
				       "P7 * +FU *  *  *  * -KY * -GI\n"
				       "P8 *  *  *  *  * -KI *  *  * \n"
				       "P9-RY+KE+KI *  *  *  * +KI+OU\n"
				       "P+00FU00FU00FU00FU00FU\n"
				       "P-00KA00KY00FU00FU00FU00FU00FU00FU\n"
				       "-\n").getInitialState());
  const Move move = Move(Position(2,3), LANCE, BLACK);
  KfendPredictor Kfend;
  CPPUNIT_ASSERT( Kfend.predict(state, move) );
}

void KfendPredictorTest::testChecked()
{
  const NumEffectState state(CsaString(
				       "P1+RY-KE-FU * +NK *  * -OU-FU\n"
				       "P2 *  * -GI *  * +KI * -FU * \n"
				       "P3 *  *  *  *  *  *  * +KY+GI\n"
				       "P4+FU *  *  * -UM+GI-KY * +FU\n"
				       "P5 * -FU *  *  *  *  *  * -KE\n"
				       "P6 *  * +FU *  *  *  *  *  * \n"
				       "P7 * +FU *  *  *  * -KY * -GI\n"
				       "P8 *  *  *  *  * -KI *  *  * \n"
				       "P9-RY+KE+KI *  *  *  * +KI+OU\n"
				       "P+00FU00FU00FU00FU00FU\n"
				       "P-00KA00KY00FU00FU00FU00FU00FU\n"
				       "+\n").getInitialState());
  const Move move = Move(Position(2,2), PAWN, BLACK);
  KfendPredictor Kfend;
  CPPUNIT_ASSERT( !Kfend.predict(state, move) );
}


// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
