/* effect5x3.t.cc
 */
#include "osl/progress/effect5x3.h"
#include "consistencyTest.h"
#include "osl/state/numEffectState.h"
#include "osl/apply_move/applyMove.h"
#include "osl/record/csaString.h"
#include "osl/record/csaRecord.h"
#include "osl/oslConfig.h"
#include <fstream>
#include <string>
#include <iostream>

#include <cppunit/TestCase.h>

class ProgressEffect5x3WithBonusTest : public CppUnit::TestFixture 
{
  CPPUNIT_TEST_SUITE(ProgressEffect5x3WithBonusTest);
  CPPUNIT_TEST(testConsistentUpdate);
  CPPUNIT_TEST(testMakeProgress);
  CPPUNIT_TEST(testSymmetry);
  CPPUNIT_TEST(testCountEffectPieces);
  CPPUNIT_TEST_SUITE_END();
public:
  void testLoad();
  void testConsistentUpdate();
  void testMakeProgress();
  void testSymmetry();
  void testCountEffectPieces();
};

CPPUNIT_TEST_SUITE_REGISTRATION(ProgressEffect5x3WithBonusTest);

using namespace osl;
using namespace osl::progress;

void ProgressEffect5x3WithBonusTest::testConsistentUpdate()
{
  consistencyTestUpdate<Effect5x3WithBonus>();
}

static int slowMakeProgressArea(Player attack, const NumEffectState& state,
				  Position king)
{  
  const Position center = Centering5x3::adjustCenter(king);

  const int min_x = center.x() - 2;
  const int max_x = center.x() + 2;
  const int min_y = center.y() - 1;
  const int max_y = center.y() + 1;


  // 利き
  int sum_effect = 0;

  for (int x=min_x; x<=max_x; ++x)
    {
      for (int y=min_y; y<=max_y; ++y)
	{
	  const Position target(x,y);
	  sum_effect += state.countEffect(attack, target) * 16;
	  sum_effect -= (state.countEffect(attack, target) *
			 std::abs(king.x() - x));
	}
    }
  return sum_effect / 2;
}

void ProgressEffect5x3WithBonusTest::testMakeProgress()
{
  using namespace osl;

  extern bool isShortTest;
  std::ifstream ifs(OslConfig::testCsaFile("FILES"));
  CPPUNIT_ASSERT(ifs);
  std::string file_name;
  for (int i=0;i<(isShortTest ? 10 : 200) && (ifs >> file_name) ; i++)
  {
    if (file_name == "") 
      break;
    file_name = OslConfig::testCsaFile(file_name);

    const Record rec=CsaFile(file_name).getRecord();
    const vector<osl::Move> moves=rec.getMoves();

    NumEffectState state(rec.getInitialState());
    
    for (unsigned int i=0; i<moves.size(); i++){
      const Move m = moves[i];
      ApplyMoveOfTurn::doMove(state, m);
      const Position bk=state.getKingPosition(BLACK);
      const Position wk=state.getKingPosition(WHITE);
      int w0=osl::progress::Effect5x3WithBonus::makeProgress(WHITE,state);
      int w1=slowMakeProgressArea(BLACK,state,wk)+
	osl::progress::Effect5x3WithBonus::makeProgressStand(BLACK,state);
      CPPUNIT_ASSERT_EQUAL(w0,w1);
      int b0=osl::progress::Effect5x3WithBonus::makeProgress(BLACK,state);
      int b1=slowMakeProgressArea(WHITE,state,bk)+
	osl::progress::Effect5x3WithBonus::makeProgressStand(WHITE,state);
      CPPUNIT_ASSERT_EQUAL(b0,b1);
    }
  }
}

void ProgressEffect5x3WithBonusTest::testSymmetry()
{
  using namespace osl;

  extern bool isShortTest;
  std::ifstream ifs(OslConfig::testCsaFile("FILES"));
  CPPUNIT_ASSERT(ifs);
  std::string file_name;
  for (int i=0;i<(isShortTest ? 10 : 200) && (ifs >> file_name) ; i++)
  {
    if (file_name == "") 
      break;
    file_name = OslConfig::testCsaFile(file_name);

    const Record rec=CsaFile(file_name).getRecord();
    const vector<osl::Move> moves=rec.getMoves();

    NumEffectState state(rec.getInitialState());
    progress::Effect5x3WithBonus progress(state);
    for (unsigned int i=0; i<moves.size(); i++){
      const Move m = moves[i];
      ApplyMoveOfTurn::doMove(state, m);
      progress.update(state, m);

      NumEffectState state_r(state.rotate180());
      progress::Effect5x3WithBonus progress_r(state_r);
      CPPUNIT_ASSERT_EQUAL(progress.progress16(BLACK).value(), progress_r.progress16(WHITE).value());
      CPPUNIT_ASSERT_EQUAL(progress.progress16(WHITE).value(), progress_r.progress16(BLACK).value());
      if (progress.progress16bonus(BLACK).value() != progress_r.progress16bonus(WHITE).value()
	  || progress.progress16bonus(WHITE).value() != progress_r.progress16bonus(BLACK).value()) 
      {
	std::cerr << "unsymmetry found\n" << state
		  << progress.progress16bonus(BLACK).value() << " != " << progress_r.progress16bonus(WHITE).value()
		  << " || "
		  << progress.progress16bonus(WHITE).value() << " != " << progress_r.progress16bonus(BLACK).value()
		  << "\n";
      }
      CPPUNIT_ASSERT_EQUAL(progress.progress16bonus(BLACK).value(), progress_r.progress16bonus(WHITE).value());
      CPPUNIT_ASSERT_EQUAL(progress.progress16bonus(WHITE).value(), progress_r.progress16bonus(BLACK).value());
    }
  }
}

void ProgressEffect5x3WithBonusTest::testCountEffectPieces()
{
  {
    NumEffectState state(CsaString(
			   "P1-KY-KE-GI-KI-OU-KI-GI-KE-KY\n"
			   "P2 *  *  *  *  *  *  * -KA * \n"
			   "P3-FU-FU-FU-FU-FU-FU * -FU-FU\n"
			   "P4 *  *  *  *  *  * -FU *  * \n"
			   "P5 *  *  * -HI * +FU *  *  * \n"
			   "P6 *  *  *  *  *  *  *  *  * \n"
			   "P7+FU+FU+FU+FU+FU * +FU+FU+FU\n"
			   "P8 * +KA *  *  *  *  * +HI * \n"
			   "P9+KY+KE+GI+KI+OU+KI+GI+KE+KY\n"
			   "+\n").getInitialState());
    Effect5x3WithBonus progress(state);
    CPPUNIT_ASSERT_EQUAL(0, progress.countEffectPieces(state, BLACK));
    CPPUNIT_ASSERT_EQUAL(2, progress.countEffectPieces(state, WHITE));
  }

  {
    NumEffectState state(CsaString(
			   "P1-OU-KE-KI-KI * +RY *  *  * \n"
			   "P2-KY-GI-KI *  *  *  * -FU-KY\n"
			   "P3-FU-FU * -KY * +TO *  *  * \n"
			   "P4 *  * -FU-FU * +KA *  * -FU\n"
			   "P5 *  *  *  * +GI *  * -KE * \n"
			   "P6+FU+UM+FU * +FU *  *  * +FU\n"
			   "P7 * +FU * +FU *  *  *  *  * \n"
			   "P8+KY+GI+GI *  *  *  *  *  * \n"
			   "P9+OU+KE+KI *  *  * -RY *  * \n"
			   "P+00KE00FU00FU00FU00FU00FU\n"
			   "+\n").getInitialState());
    Effect5x3WithBonus progress(state);
    CPPUNIT_ASSERT_EQUAL(3, progress.countEffectPieces(state, BLACK));
    CPPUNIT_ASSERT_EQUAL(1, progress.countEffectPieces(state, WHITE));
  }
}

/* ------------------------------------------------------------------------- */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
