/* myshogi.cc
 */
#include "osl/record/myshogi.h"
#include "osl/pieceStand.h"
#include <boost/foreach.hpp>
#include <sstream>

std::string osl::record::
myshogi::show(const NumEffectState& state)
{
  std::ostringstream os;
  os << "\\begin{myshogi} \\banmen \n";
  os << "\\mochigoma{\\sente}";
  BOOST_FOREACH(Ptype ptype, PieceStand::order)
    os << "{" << state.countPiecesOnStand(BLACK, ptype) << "}";
  os << "\n\\mochigoma{\\gote}";
  BOOST_FOREACH(Ptype ptype, PieceStand::order)
    os << "{" << state.countPiecesOnStand(WHITE, ptype) << "}";
  os << "\n";
  for (int i=0; i<Piece::SIZE; ++i)
  {
    const Piece p = state.getPieceOf(i);
    if (p.isOnBoard())
      os << show(p);
    if (i % 2)
      os << "\n";
  }
  os << "\\end{myshogi}\n";
  return os.str();
}

std::string osl::record::
myshogi::show(Ptype p)
{
  static CArray<std::string, PTYPE_SIZE> names = {{
      "", "", 
      "\\tokin", "\\narikyou", "\\narikei", "\\narigin", "\\uma", "\\ryu", 
      "\\ou", // todo: \\gyoku   
      "\\kin", "\\fu", "\\kyou", "\\kei", "\\gin", "\\kaku", "\\hi"
    }};
  return names[p];
}

std::string osl::record::
myshogi::show(Position p)
{
  std::string ret = "xx";
  ret[0] = '0'+p.x();
  ret[1] = '0'+p.y();
  return ret;
}

std::string osl::record::
myshogi::show(Piece p)
{
  if (! p.isOnBoard())
    return "";
  return std::string("\\koma{") + show(p.position()) + "}"
    + "{" + show(p.owner()) + "}{" + show(p.ptype()) + "}";
}

std::string osl::record::
myshogi::show(Player p)
{
  return p == BLACK ? "\\sente" : "\\gote";
}
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
