#include "osl/misc/fastCopier.h"
#include "osl/record/csaRecord.h"
#include "osl/state/numEffectState.h"
#include "osl/apply_move/applyMove.h"
#include "osl/oslConfig.h"
#include <cppunit/TestCase.h>
#include <cppunit/extensions/HelperMacros.h>

class FastCopierTest : public CppUnit::TestFixture 
{
  CPPUNIT_TEST_SUITE( FastCopierTest );
  CPPUNIT_TEST(testCopy);
  CPPUNIT_TEST(testFile);
  CPPUNIT_TEST_SUITE_END();
public:
  void testCopy();
  void testFile();
};

CPPUNIT_TEST_SUITE_REGISTRATION(FastCopierTest);

using namespace osl;

void FastCopierTest::testCopy()
{
  NumEffectState state, state2;
  CPPUNIT_ASSERT(state.isConsistent());
  CPPUNIT_ASSERT(state2.isConsistent());

  misc::FastCopier::copy(&state2, &state);

  CPPUNIT_ASSERT(state.isConsistent());
  CPPUNIT_ASSERT(state2.isConsistent());

  ApplyMoveOfTurn::doMove(state, Move(Position(7,7), Position(7,6), PAWN, PTYPE_EMPTY, false, BLACK));

  CPPUNIT_ASSERT(state.isConsistent());
  CPPUNIT_ASSERT(state2.isConsistent());
  
  misc::FastCopier::copy(&state2, &state);

  CPPUNIT_ASSERT(state.isConsistent());
  CPPUNIT_ASSERT(state2.isConsistent());

}

void FastCopierTest::testFile()
{
  NumEffectState state, state2;
  std::ifstream ifs(OslConfig::testCsaFile("FILES"));
  CPPUNIT_ASSERT(ifs);
  std::string filename;
  while ((ifs >> filename)) {
    if (filename == "") 
      break;
    Record record=CsaFile(OslConfig::testCsaFile(filename)).getRecord();
    state = NumEffectState(record.getInitialState());
    vector<Move> moves=record.getMoves();

    for (size_t i=0; i<moves.size(); ++i) {
      CPPUNIT_ASSERT(state.isConsistent());
      CPPUNIT_ASSERT(state2.isConsistent());

      ApplyMoveOfTurn::doMove(state, moves[i]);
      misc::FastCopier::copy(&state2, &state);

      CPPUNIT_ASSERT(state.isConsistent());
      CPPUNIT_ASSERT(state2.isConsistent());
    }
  }
}
