#include "osl/record/opening/openingBook.h"
#include "osl/record/csa.h"
#include "osl/search/quiescenceSearch2.h"
#include "osl/search/quiescenceSearch2.tcc"
#include "osl/eval/pieceEval.h"
#include "osl/stl/vector.h"
#include <iostream>
#include <cstring>

using namespace osl::record::opening;


static int qsearch(osl::state::SimpleState &s, osl::Move lastMove)
{
  typedef osl::search::QuiescenceSearch2<osl::eval::PieceEval> qsearch_t;

  osl::state::NumEffectState state(s);
  osl::search::SimpleHashTable table(100000, -16, false);
  osl::search::SearchState2Core::checkmate_t checkmate_searcher;
  osl::search::SearchState2Core core(state, checkmate_searcher);
  qsearch_t qs(core, table);
  osl::eval::PieceEval ev(state);
  return qs.search(state.getTurn(), ev, lastMove);
}

int main(int argc, char **argv)
{
  if (argc != 2)
  {
    std::cerr << "Usage: " << argv[0] << " FILENAME" << std::endl;
    return 1;
  }

  WeightedBook book(argv[1]);
  bool states[book.getTotalState()];

  memset(states, 0, sizeof(bool) * book.getTotalState());
  osl::stl::vector<int> stateToVisit;

  stateToVisit.push_back(book.getStartState());
  const int threshold = osl::eval::Ptype_Eval_Table.value(osl::SILVER);

  while (!stateToVisit.empty())
  {
    const int stateIndex = stateToVisit.back();
    stateToVisit.pop_back();
    states[stateIndex] = true;

    osl::state::SimpleState state = book.getBoard(stateIndex);
    int value = qsearch(state,
			osl::Move::PASS(alt(state.getTurn())));

    const osl::stl::vector<WMove> moves = book.getMoves(stateIndex);
    for (size_t i = 0; i < moves.size(); i++)
    {
      const int nextIndex = moves[i].getStateIndex();
      osl::state::SimpleState newState = book.getBoard(nextIndex);
      osl::Move move = moves[i].getMove();
      int newValue = qsearch(newState, move);

      int diff = newValue - value;

      // the loss too big
      if ((state.getTurn() == osl::BLACK && diff < -threshold)
	  || (state.getTurn() == osl::WHITE && diff > threshold))
	std::cout << "----" << std::endl
		  << state << osl::record::csa::show(move) << std::endl;
      // the gain too big
      if ((state.getTurn() == osl::BLACK && diff > threshold)
	  || (state.getTurn() == osl::WHITE && diff < -threshold))
	std::cout << "++++" << std::endl
		  << state << osl::record::csa::show(move) << std::endl;

      if (! states[nextIndex])
      {
	stateToVisit.push_back(nextIndex);
      }
    }
  }
}
