/* usiReporter.cc
 */
#include "osl/search/usiReporter.h"
#include "osl/record/usi.h"
#include "osl/misc/lightMutex.h"
#include "osl/misc/milliSeconds.h"
#include "osl/oslConfig.h"
#include <iostream>

void osl::search::
UsiReporter::newDepth(int depth)
{
  if (OslConfig::usiModeInSilent())
    return;
  std::ostream& os = std::cout;
  os << "info depth " << depth << "\n";
}
void osl::search::
UsiReporter::showPV(int depth, size_t node_count, double elapsed, int value, Move cur, const Move *first, const Move *last, bool ignore_silent)
{
  if (OslConfig::usiModeInSilent() && ! ignore_silent)
    return;
  int seldepth = last-first;
  if (last - first && *first != cur)
    ++seldepth;
  if (ignore_silent)
    std::cerr << "info depth " << depth << " seldepth " << seldepth
	      << " time " << static_cast<int>(elapsed*1000) << " score cp " << value
	      << " nodes " << node_count
	      << " nps " << static_cast<int>(node_count/elapsed)
	      << " pv " << record::usi::show(cur) << "\n";
  std::ostream& os = std::cout;
  os << "info depth " << depth << " seldepth " << seldepth
     << " time " << static_cast<int>(elapsed*1000) << " score cp " << value
     << " nodes " << node_count << " nps " << static_cast<int>(node_count/elapsed);
  os << " pv " << record::usi::show(cur);
  if (first != last) {
    if (cur == *first)
      ++first;
    while (first != last) {
      os << ' ' << record::usi::show(*first++);
    }
  }
  os << "\n";
}

static osl::misc::LightMutex usi_root_move_mutex;
void osl::search::
UsiReporter::rootMove(Move cur, bool allow_frequent_display)
{
  if (OslConfig::usiModeInSilent())
    return;
  static MilliSeconds prev;
  if (! allow_frequent_display) 
  {
    MilliSeconds now = MilliSeconds::now();
    {
      SCOPED_LOCK(lk, usi_root_move_mutex);
      if ((now - prev).toSeconds() < 0.5)
	return;
      prev = now;
    }
  }
  std::ostream& os = std::cout;
  os << "info currmove " << record::usi::show(cur) << "\n";
}

void osl::search::
UsiReporter::timeInfo(size_t node_count, double elapsed)
{
  if (OslConfig::usiModeInSilent())
    return;
  std::ostream& os = std::cout;
    os << "info time " << static_cast<int>(elapsed*1000)
       << " nodes " << node_count << " nps " << static_cast<int>(node_count/elapsed) << "\n";
  os << std::flush;
}

void osl::search::
UsiReporter::hashInfo(double ratio)
{
  if (OslConfig::usiModeInSilent())
    return;
  std::ostream& os = std::cout;
    os << "info hashfull " << static_cast<int>(ratio*1000) << "\n";
  os << std::flush;
}



osl::search::
UsiMonitor::~UsiMonitor()
{
}

void osl::search::
UsiMonitor::newDepth(int depth)
{
  UsiReporter::newDepth(depth);
  last_root_move = Move();
}

void osl::search::
UsiMonitor::showPV(int depth, size_t node_count, double elapsed, int value, Move cur, const Move *first, const Move *last)
{
  UsiReporter::showPV(depth, node_count, elapsed, value, cur, first, last);
}

void osl::search::
UsiMonitor::rootMove(Move cur)
{
  last_root_move = cur;
}

void osl::search::
UsiMonitor::rootFirstMove(Move cur)
{
  last_root_move = cur;
  UsiReporter::rootMove(cur, true);
}

void osl::search::
UsiMonitor::timeInfo(size_t node_count, double elapsed)
{
  UsiReporter::timeInfo(node_count, elapsed);
  UsiReporter::rootMove(last_root_move);
}

void osl::search::
UsiMonitor::hashInfo(double ratio)
{
  UsiReporter::hashInfo(ratio);
}

void osl::search::
UsiMonitor::rootForcedMove(Move the_move)
{
  if (OslConfig::usiModeInSilent())
    return;
  std::ostream& os = std::cout;
  os << "info string forced move at the root: "
     << record::usi::show(the_move) << "\n";
  os << std::flush;
}

void osl::search::
UsiMonitor::rootLossByCheckmate()
{
  if (OslConfig::usiModeInSilent())
    return;
  std::ostream& os = std::cout;
  os << "info string loss by checkmate\n";
  os << std::flush;
}

// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
