#ifndef _COMPACT_BOARD_H
#define _COMPACT_BOARD_H
#include "osl/state/simpleState.h"
#include "osl/stl/vector.h"
#include <string>

namespace osl
{
  namespace record
  {
    class OPiece
    {
    public:
      OPiece(Piece p)
      {
	const Position pos = p.position();
	const int bitPos = position2Bits(pos);
	value = (static_cast<int>(p.owner()) << 20 |
		 static_cast<int>(p.ptype()) << 16 | bitPos);
      }
      OPiece(int i)
      {
	value = i;
      }
      Position getPosition() const
      {
        return bits2Position(value);
      }
      Ptype getPtype() const
      {
	return static_cast<Ptype>((value >> 16) & 0xf);
      }
      Player getOwner() const
      {
	return static_cast<Player>(value >> 20);
      }
      operator int() const { return value; }

      /** Converts a position to an integer (bits) */
      static int position2Bits(const Position& pos);
      /** Converts an integer (bits) to Position */
      static Position bits2Position(const int bit_position);
    private:
      int value;
    };

    class CompactBoard;
    /**
     * 局面を比較する. 
     * 将棋としての局面（手番や持ち駒を含む）を比較する. 
     * NumEffectState等と異なり駒番号は考慮されない.
     */
    bool operator==(const CompactBoard&, const CompactBoard&);
    std::ostream& operator<<(std::ostream& os, const CompactBoard& c);
    std::istream& operator>>(std::istream& os, CompactBoard& c);
    /**
     * SimpleStateよりcompactな局面の表現 
     */
    class CompactBoard
    {
    public:
      CompactBoard() {}
      explicit CompactBoard(const SimpleState& state);
      SimpleState getState() const;
      const osl::vector<OPiece>& getPieces() const {return pieces;};
      Player getTurn() const {return turn;}

      std::string toBase64() const;
      static const CompactBoard fromBase64(const std::string& str);

      friend std::ostream& operator<<(std::ostream& os, const CompactBoard& c);
      friend std::istream& operator>>(std::istream& os, CompactBoard& c);
      friend bool operator==(const CompactBoard&, const CompactBoard&);
    private:
      osl::vector<OPiece> pieces;
      Player turn;
    };
  }
}

#endif // _COMPACT_BOARD_H
/* ------------------------------------------------------------------------- */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
