/* safeMove.h
 */
#ifndef _MOVE_CLASSIFIER_SAFE_MOVE_H
#define _MOVE_CLASSIFIER_SAFE_MOVE_H
#include "osl/position.h"
#include "osl/player.h"
#include "osl/ptype.h"
#include "osl/piece.h"
#include "osl/move_classifier/kingOpenMove.h"
#include "osl/move_classifier/classifierTraits.h"
namespace osl
{
  namespace move_classifier
  {
    /**
     * 元々，手番の玉に王手がかかっていない状態で自殺手でないことをチェック.
     * DropMoveの時には呼べない
     */
    template <Player P>
    struct SafeMove
    {
      static bool isMember(const NumEffectState& state, 
			   Ptype ptype,Position from,Position to)
      {
	assert(! from.isPieceStand());
	assert(state.getPieceOnBoard(from).owner() == P);
	/**
	 * 元々王手がかかっていないと仮定しているので，自分を
	 * 取り除いた上でhasEffectByを呼ばなくても良い
	 */
	if (ptype==KING)
	  return ! state.template hasEffectBy<PlayerTraits<P>::opponent>(to);
	return ! KingOpenMove<P>::isMember(state,ptype,from,to);
      }
    };

    static inline bool isSafeMove(NumEffectState& state, Move move)
    {
      const Position from = move.from();
      if (from.isPieceStand())
	return true;
      const Player turn = move.player();
      const Ptype ptype = move.ptype();
      const Position to = move.to();
      
      if (turn == BLACK)
	return SafeMove<BLACK>::isMember(state, ptype, from, to);
      else
	return SafeMove<WHITE>::isMember(state, ptype, from, to);
    }
    template <Player P> struct ClassifierTraits<SafeMove<P> >
    {
      static const bool drop_suitable = false;
      static const bool result_if_drop = true;
    };
  }
  using move_classifier::isSafeMove;
}
#endif /* _MOVE_CLASSIFIER_SAFE_MOVE_H */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
