/*
    $Id: nss-shadow.h,v 1.11 2002/07/05 19:20:46 gmorin Exp $
    $Source: /cvsroot/nss-mysql/nss-mysql/src/nss-shadow.h,v $
    $Date: 2002/07/05 19:20:46 $
    $Author: gmorin $
*/

#ifndef _HAVE_NSS_MYSQL_SHADOW_H
#define _HAVE_NSS_MYSQL_SHADOW_H

#include <mysql.h>
#include <shadow.h>
#include <pthread.h>
#include "nss-mysql.h"

struct shadowoptions {
        struct connection_options con;
        char * table; /* table */
        char * where; /* where clause */
        char * usercolumn; /* user field */
        char * passwdcolumn; /* password field */
        char * useridcolumn; /* userid column */
        char * lastchange; /* Date of last change */
        char * min; /* Minimum number of days between changes */
        char * max; /* Maximum number of days between changes */
        char * warn; /*  Number of days to warn user to change the password */
        char * inact; /* Number of days the account may be inactive. */
        char * expire; /* * Number of days since 1970-01-01 until account expired */
};


NSS_STATUS _nss_mysql_shadow_read_db(const char *uname, char * name, int bulk,
                int *errnop, MYSQL * mysql_auth, 
                struct shadowoptions * soptions, pthread_mutex_t *m,
                MYSQL_RES ** result);

NSS_STATUS _nss_mysql_shadow_result_to_struct(struct spwd *spw,
                MYSQL_RES * result,int * errnop, char * buffer, size_t buflen,
                unsigned long max);

#endif
